/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelUMLModifier;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class ObjectModelAttributeImpl
extends ObjectModelParameterImpl
implements ObjectModelAttribute {
    public static final String ATTRIBUTE_TYPE_AGGREGATE = "aggregate";
    public static final String ATTRIBUTE_TYPE_SHARED = "shared";
    public static final String ATTRIBUTE_TYPE_COMPOSITE = "composite";
    public static final ObjectModelJavaModifier DEFAULT_VISIBILITY = ObjectModelJavaModifier.PROTECTED;
    protected String reverseAttributeName;
    protected int reverseMaxMultiplicity = -1;
    protected ObjectModelClassifier reference;
    protected String associationClassName;
    private static Set<ObjectModelModifier> authorizedModifiers;

    public ObjectModelAttributeImpl() {
        this.addModifier(ObjectModelUMLModifier.NAVIGABLE);
    }

    protected void mergeFrom(ObjectModelAttributeImpl source) {
        super.mergeFrom(source);
    }

    @Override
    public void postInit() {
        if (this.name == null) {
            this.name = GeneratorUtil.toLowerCaseFirstLetter(GeneratorUtil.getClassNameFromQualifiedName(this.type));
        }
        super.postInit();
    }

    public void setReverseAttributeName(String reverseAttributeName) {
        this.reverseAttributeName = reverseAttributeName;
    }

    public void setAssociationType(String associationType) {
        this.removeModifiers(ObjectModelUMLModifier.associationTypes);
        if (ATTRIBUTE_TYPE_SHARED.equals(associationType) || ATTRIBUTE_TYPE_AGGREGATE.equals(associationType)) {
            this.addModifier(ObjectModelUMLModifier.AGGREGATE);
        } else if (ATTRIBUTE_TYPE_COMPOSITE.equals(associationType)) {
            this.addModifier(ObjectModelUMLModifier.COMPOSITE);
        } else {
            throw new IllegalArgumentException("Unexpected association type: " + associationType);
        }
    }

    public void setReverseMaxMultiplicity(int reverseMaxMultiplicity) {
        this.reverseMaxMultiplicity = reverseMaxMultiplicity;
    }

    public void setVisibility(String visibility) {
        ObjectModelJavaModifier modifier = ObjectModelJavaModifier.fromVisibility(visibility);
        this.removeModifiers(ObjectModelJavaModifier.visibilityModifiers);
        if (modifier == null) {
            modifier = DEFAULT_VISIBILITY;
        }
        this.addModifier(modifier);
    }

    public void setFinal(boolean isFinal) {
        this.addOrRemoveModifier(ObjectModelJavaModifier.FINAL, isFinal);
    }

    public void setTransient(boolean isTransient) {
        this.addOrRemoveModifier(ObjectModelJavaModifier.TRANSIENT, isTransient);
    }

    @Override
    public void setStatic(boolean isStatic) {
        super.setStatic(isStatic);
    }

    @Override
    protected Set<ObjectModelModifier> getAuthorizedModifiers() {
        if (authorizedModifiers == null) {
            HashSet modifiers = Sets.newHashSet((Object[])new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.TRANSIENT, ObjectModelJavaModifier.VOLATILE, ObjectModelUMLModifier.AGGREGATE, ObjectModelUMLModifier.COMPOSITE, ObjectModelUMLModifier.NAVIGABLE, ObjectModelUMLModifier.ORDERED, ObjectModelUMLModifier.UNIQUE});
            Iterables.addAll((Collection)modifiers, ObjectModelJavaModifier.visibilityModifiers);
            authorizedModifiers = ImmutableSet.copyOf((Collection)modifiers);
        }
        return authorizedModifiers;
    }

    public void setNavigable(boolean navigable) {
        this.addOrRemoveModifier(ObjectModelUMLModifier.NAVIGABLE, navigable);
    }

    @Override
    public void setUnique(boolean isUnique) {
        super.setUnique(isUnique);
    }

    @Override
    public boolean isAggregate() {
        return this.modifiers.contains(ObjectModelUMLModifier.AGGREGATE);
    }

    @Override
    public boolean isComposite() {
        return this.modifiers.contains(ObjectModelUMLModifier.COMPOSITE);
    }

    @Override
    public String getVisibility() {
        String visibility = DEFAULT_VISIBILITY.toString();
        if (this.modifiers.contains(ObjectModelJavaModifier.PUBLIC)) {
            visibility = ObjectModelJavaModifier.PUBLIC.toString();
        } else if (this.modifiers.contains(ObjectModelJavaModifier.PRIVATE)) {
            visibility = ObjectModelJavaModifier.PRIVATE.toString();
        }
        if (this.modifiers.contains(ObjectModelJavaModifier.PACKAGE)) {
            visibility = ObjectModelJavaModifier.PACKAGE.toString();
        }
        return visibility;
    }

    public void setAssociationClassName(String associationClassName) {
        this.associationClassName = associationClassName;
    }

    @Override
    public boolean referenceClassifier() {
        return this.getClassifier() != null;
    }

    @Override
    public ObjectModelClassifier getClassifier() {
        return this.getModel().getClassifier(this.type);
    }

    @Override
    public ObjectModelAttribute getReverseAttribute() {
        ObjectModelAttribute reverseAttribute = null;
        ObjectModelClassifier classifier = this.getClassifier();
        if (classifier instanceof ObjectModelClass) {
            reverseAttribute = classifier.getAttribute(this.getReverseAttributeName());
        }
        return reverseAttribute;
    }

    @Override
    public String getReverseAttributeName() {
        if (StringUtils.isEmpty((CharSequence)this.reverseAttributeName)) {
            this.reverseAttributeName = GeneratorUtil.toLowerCaseFirstLetter(this.getDeclaringElement().getName());
        }
        return this.reverseAttributeName;
    }

    @Override
    public String getName() {
        if (StringUtils.isEmpty((CharSequence)this.name) && this.getClassifier() != null) {
            this.name = GeneratorUtil.toLowerCaseFirstLetter(this.getClassifier().getName());
        }
        return this.name;
    }

    @Override
    public int getReverseMaxMultiplicity() {
        return this.reverseMaxMultiplicity;
    }

    @Override
    public ObjectModelClass getAssociationClass() {
        return this.getModel().getClass(this.associationClassName);
    }

    @Override
    public boolean hasAssociationClass() {
        return this.getAssociationClass() != null;
    }

    @Override
    public boolean isFinal() {
        return this.modifiers.contains(ObjectModelJavaModifier.FINAL);
    }

    @Override
    public boolean isTransient() {
        return this.modifiers.contains(ObjectModelJavaModifier.TRANSIENT);
    }

    @Override
    public boolean isNavigable() {
        return this.modifiers.contains(ObjectModelUMLModifier.NAVIGABLE);
    }

    @Override
    public ObjectModelImplRef addStereotype(ObjectModelImplRef stereotype) {
        String stereotypeName = stereotype.getName();
        if (EugeneCoreTagValues.Store.ordered.getName().equals(stereotypeName)) {
            this.setOrdered(true);
        }
        return super.addStereotype(stereotype);
    }
}

