/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;

public class ExternalCacheExtension {
    private static final Logger log = LogManager.getLogger(ExternalCacheExtension.class);
    public static final String OBJECTMODEL_EXTENSION = "externalClassifiers";
    protected Map<String, ObjectModelClassifierImpl> cache = new HashMap<String, ObjectModelClassifierImpl>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <C extends ObjectModelClassifierImpl> C getCache(ObjectModelImplRef reference, Class<C> classifierClass) throws RuntimeException {
        ObjectModelClassifierImpl result;
        ObjectModelClassifierImpl classifier = this.cache.get(reference.getName());
        if (classifier != null && !classifierClass.isAssignableFrom(classifier.getClass())) {
            throw new ClassCastException("Invalid cast for " + classifierClass.getName());
        }
        if (classifier == null) {
            try {
                result = (ObjectModelClassifierImpl)classifierClass.newInstance();
                this.addClassifierToCache(reference, result);
                if (!log.isDebugEnabled()) return (C)result;
                log.debug("Add '" + reference.getName() + "' to external cache");
                return (C)result;
            }
            catch (Exception eee) {
                throw new RuntimeException("Unable to add new '" + classifierClass.getName() + "' to cache for '" + reference.getName() + "'", eee);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Get '" + reference.getName() + "' from external cache");
            }
            result = classifier;
        }
        return (C)result;
    }

    protected void addClassifierToCache(ObjectModelImplRef reference, ObjectModelClassifierImpl classifier) {
        String fqn = reference.getName();
        String packageName = GeneratorUtil.getParentPackageName(fqn);
        String name = GeneratorUtil.getClassNameFromQualifiedName(fqn);
        classifier.setName(name);
        classifier.setPackage(packageName);
        classifier.postInit();
        classifier.setExtern(true);
        this.cache.put(reference.getName(), classifier);
    }
}

