/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.validator;

import java.util.HashMap;
import java.util.Map;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;

public abstract class NameBasedValidator
extends ObjectModelValidator {
    private boolean caseSensitive;
    private Map<String, String> namesAndReasons;

    public NameBasedValidator(ObjectModel model, boolean caseSensitive) {
        super(model);
        this.caseSensitive = caseSensitive;
    }

    private Map<String, String> getNameAndReasons() {
        if (this.namesAndReasons == null) {
            this.namesAndReasons = new HashMap<String, String>();
        }
        return this.namesAndReasons;
    }

    public void addNameAndReason(String name, String reason) {
        if (name != null) {
            if (!this.caseSensitive) {
                name = name.toLowerCase();
            }
            this.getNameAndReasons().put(name, reason);
        }
    }

    public void addNamesAndReasons(Map<String, String> namesAndReasons) {
        for (String key : namesAndReasons.keySet()) {
            this.addNameAndReason(key, namesAndReasons.get(key));
        }
    }

    public boolean containsName(String name) {
        if (!this.caseSensitive) {
            name = name.toLowerCase();
        }
        return this.getNameAndReasons().containsKey(name);
    }

    public String getReason(String name) {
        if (!this.caseSensitive) {
            name = name.toLowerCase();
        }
        return this.getNameAndReasons().get(name);
    }
}

