/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader.yaml;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.eugene.models.object.reader.yaml.KeyWords;
import org.nuiton.eugene.models.object.reader.yaml.YamlObject;
import org.nuiton.eugene.models.object.reader.yaml.YamlUtil;

public class ParserUserFriendly
implements KeyWords {
    protected Map<String, String> imports = new LinkedHashMap<String, String>();
    protected Map<String, String> importsI = new LinkedHashMap<String, String>();
    protected Map<String, String> importsE = new LinkedHashMap<String, String>();
    protected String packageM = "default";
    protected Object modelYAML;
    protected YamlObject modelYAMLO;

    public ParserUserFriendly(Object modelYAML, YamlObject modelYAMLO) {
        this.modelYAML = modelYAML;
        this.modelYAMLO = modelYAMLO;
    }

    public void parseModel() {
        if (this.modelYAML instanceof Map) {
            for (Map.Entry entry : ((Map)this.modelYAML).entrySet()) {
                List<String> tmp;
                if (!(entry instanceof Map.Entry)) continue;
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                if (key.equals("package")) {
                    this.modelYAMLO.addStringToMap("package", String.valueOf(value));
                    this.packageM = String.valueOf(value);
                }
                if (key.equals("name")) {
                    this.modelYAMLO.addStringToMap("name", String.valueOf(value));
                }
                if (key.equals("version")) {
                    this.modelYAMLO.addStringToMap("version", String.valueOf(value));
                }
                if (key.equals("imports") && value instanceof List) {
                    for (Object imp : (List)value) {
                        this.importsE.put(YamlUtil.afterChar(String.valueOf(imp), Character.valueOf('.')), String.valueOf(imp));
                    }
                }
                if ((tmp = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'))).contains("class")) {
                    YamlObject classYAMLO = new YamlObject();
                    this.parseClass(key, value, classYAMLO);
                    this.modelYAMLO.addYamlObjectToMap("class", classYAMLO);
                    continue;
                }
                if (tmp.contains("interface")) {
                    YamlObject interfaceYAMLO = new YamlObject();
                    this.parseInterface(key, value, interfaceYAMLO);
                    this.modelYAMLO.addYamlObjectToMap("interface", interfaceYAMLO);
                    continue;
                }
                if (tmp.contains("associationclass")) {
                    YamlObject associationClassYAMLO = new YamlObject();
                    this.parseAssociationClass(key, value, associationClassYAMLO);
                    this.modelYAMLO.addYamlObjectToMap("associationclass", associationClassYAMLO);
                    continue;
                }
                if (!tmp.contains("enumeration")) continue;
                YamlObject enumerationYAMLO = new YamlObject();
                this.parseEnumeration(key, value, enumerationYAMLO);
                this.modelYAMLO.addYamlObjectToMap("enumeration", enumerationYAMLO);
            }
        }
    }

    public void parseClass(String key, Object value, YamlObject classYAMLO) {
        List<String> classPARSE = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'));
        if (classPARSE.contains("class")) {
            classPARSE.remove(classPARSE.indexOf("class"));
        }
        if (classPARSE.contains("abstract")) {
            classYAMLO.addStringToMap("abstract", String.valueOf(true));
            classPARSE.remove(classPARSE.indexOf("abstract"));
        }
        if (classPARSE.contains("static")) {
            classYAMLO.addStringToMap("static", String.valueOf(true));
            classPARSE.remove(classPARSE.indexOf("static"));
        }
        if (classPARSE.contains("extern")) {
            classYAMLO.addStringToMap("extern", String.valueOf(true));
            classPARSE.remove(classPARSE.indexOf("extern"));
        }
        if (classPARSE.contains("inner")) {
            classYAMLO.addStringToMap("inner", String.valueOf(true));
            classPARSE.remove(classPARSE.indexOf("inner"));
        }
        if (classPARSE.contains("public")) {
            classYAMLO.addStringToMap("visibility", "public");
            classPARSE.remove(classPARSE.indexOf("public"));
        } else if (classPARSE.contains("private")) {
            classYAMLO.addStringToMap("visibility", "private");
            classPARSE.remove(classPARSE.indexOf("private"));
        } else if (classPARSE.contains("protected")) {
            classYAMLO.addStringToMap("visibility", "protected");
            classPARSE.remove(classPARSE.indexOf("protected"));
        }
        for (String string : classPARSE) {
            if (!string.contains("<<") || !string.contains(">>")) continue;
            LinkedList<Character> targets = new LinkedList<Character>();
            targets.add(Character.valueOf('<'));
            targets.add(Character.valueOf('>'));
            String str2 = YamlUtil.removeMultiChar(string, targets);
            targets = new LinkedList();
            targets.add(Character.valueOf(' '));
            targets.add(Character.valueOf(','));
            List<String> list = YamlUtil.multiCharParse(str2, targets);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String str3 = (String)iterator.next();
                classYAMLO.addStringToMap("stereotypes", str3);
            }
        }
        if (classPARSE.size() > 0) {
            String name = classPARSE.get(0);
            classYAMLO.addStringToMap("name", name);
            this.importsI.put(name, this.packageM + "." + name);
        }
        if (value instanceof Map) {
            for (Object object : ((Map)value).entrySet()) {
                if (!(object instanceof Map.Entry)) continue;
                String keyP = String.valueOf(((Map.Entry)object).getKey());
                Object valueP = ((Map.Entry)object).getValue();
                if (keyP.equals("superclasses")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superClass : (List)valueP) {
                        classYAMLO.addStringToMap("superclasses", String.valueOf(superClass));
                    }
                    continue;
                }
                if (keyP.equals("superinterfaces")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superInterface : (List)valueP) {
                        classYAMLO.addStringToMap("superinterfaces", String.valueOf(superInterface));
                    }
                    continue;
                }
                if (keyP.contains("(") && keyP.contains(")")) {
                    YamlObject operationYAMLO = new YamlObject();
                    this.parseOperation(keyP, valueP, operationYAMLO);
                    classYAMLO.addYamlObjectToMap("operation", operationYAMLO);
                    continue;
                }
                YamlObject attributeYAMLO = new YamlObject();
                this.parseAttribute(keyP, valueP, attributeYAMLO);
                classYAMLO.addYamlObjectToMap("attribute", attributeYAMLO);
            }
        }
    }

    public void parseInterface(String key, Object value, YamlObject interfaceYAMLO) {
        List<String> interfacePARSE = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'));
        if (interfacePARSE.contains("interface")) {
            interfacePARSE.remove(interfacePARSE.indexOf("interface"));
        }
        if (interfacePARSE.contains("abstract")) {
            interfaceYAMLO.addStringToMap("abstract", String.valueOf(true));
            interfacePARSE.remove(interfacePARSE.indexOf("abstract"));
        }
        if (interfacePARSE.contains("static")) {
            interfaceYAMLO.addStringToMap("static", String.valueOf(true));
            interfacePARSE.remove(interfacePARSE.indexOf("static"));
        }
        if (interfacePARSE.contains("extern")) {
            interfaceYAMLO.addStringToMap("extern", String.valueOf(true));
            interfacePARSE.remove(interfacePARSE.indexOf("extern"));
        }
        if (interfacePARSE.contains("inner")) {
            interfaceYAMLO.addStringToMap("inner", String.valueOf(true));
            interfacePARSE.remove(interfacePARSE.indexOf("inner"));
        }
        if (interfacePARSE.contains("public")) {
            interfaceYAMLO.addStringToMap("visibility", "public");
            interfacePARSE.remove(interfacePARSE.indexOf("public"));
        } else if (interfacePARSE.contains("private")) {
            interfaceYAMLO.addStringToMap("visibility", "private");
            interfacePARSE.remove(interfacePARSE.indexOf("private"));
        } else if (interfacePARSE.contains("protected")) {
            interfaceYAMLO.addStringToMap("visibility", "protected");
            interfacePARSE.remove(interfacePARSE.indexOf("protected"));
        }
        for (String string : interfacePARSE) {
            if (!string.contains("<<") || !string.contains(">>")) continue;
            LinkedList<Character> targets = new LinkedList<Character>();
            targets.add(Character.valueOf('<'));
            targets.add(Character.valueOf('>'));
            String str2 = YamlUtil.removeMultiChar(string, targets);
            targets = new LinkedList();
            targets.add(Character.valueOf(' '));
            targets.add(Character.valueOf(','));
            List<String> list = YamlUtil.multiCharParse(str2, targets);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String str3 = (String)iterator.next();
                interfaceYAMLO.addStringToMap("stereotypes", str3);
            }
        }
        if (interfacePARSE.size() > 0) {
            String name = interfacePARSE.get(0);
            interfaceYAMLO.addStringToMap("name", name);
            this.importsI.put(name, this.packageM + "." + name);
        }
        if (value instanceof Map) {
            for (Object object : ((Map)value).entrySet()) {
                if (!(object instanceof Map.Entry)) continue;
                String keyP = String.valueOf(((Map.Entry)object).getKey());
                Object valueP = ((Map.Entry)object).getValue();
                if (keyP.equals("superclasses")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superClass : (List)valueP) {
                        interfaceYAMLO.addStringToMap("superclasses", String.valueOf(superClass));
                    }
                    continue;
                }
                if (keyP.equals("superinterfaces")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superInterface : (List)valueP) {
                        interfaceYAMLO.addStringToMap("superinterfaces", String.valueOf(superInterface));
                    }
                    continue;
                }
                if (keyP.contains("(") && keyP.contains(")")) {
                    YamlObject operationYAMLO = new YamlObject();
                    this.parseOperation(keyP, valueP, operationYAMLO);
                    interfaceYAMLO.addYamlObjectToMap("operation", operationYAMLO);
                    continue;
                }
                YamlObject attributeYAMLO = new YamlObject();
                this.parseAttribute(keyP, valueP, attributeYAMLO);
                interfaceYAMLO.addYamlObjectToMap("attribute", attributeYAMLO);
            }
        }
    }

    public void parseAssociationClass(String key, Object value, YamlObject associationClassYAMLO) {
        List<String> associationClassPARSE = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'));
        if (associationClassPARSE.contains("associationclass")) {
            associationClassPARSE.remove(associationClassPARSE.indexOf("associationclass"));
        }
        if (associationClassPARSE.contains("abstract")) {
            associationClassYAMLO.addStringToMap("abstract", String.valueOf(true));
            associationClassPARSE.remove(associationClassPARSE.indexOf("abstract"));
        }
        if (associationClassPARSE.contains("static")) {
            associationClassYAMLO.addStringToMap("static", String.valueOf(true));
            associationClassPARSE.remove(associationClassPARSE.indexOf("static"));
        }
        if (associationClassPARSE.contains("extern")) {
            associationClassYAMLO.addStringToMap("extern", String.valueOf(true));
            associationClassPARSE.remove(associationClassPARSE.indexOf("extern"));
        }
        if (associationClassPARSE.contains("inner")) {
            associationClassYAMLO.addStringToMap("inner", String.valueOf(true));
            associationClassPARSE.remove(associationClassPARSE.indexOf("inner"));
        }
        if (associationClassPARSE.contains("public")) {
            associationClassYAMLO.addStringToMap("visibility", "public");
            associationClassPARSE.remove(associationClassPARSE.indexOf("public"));
        } else if (associationClassPARSE.contains("private")) {
            associationClassYAMLO.addStringToMap("visibility", "private");
            associationClassPARSE.remove(associationClassPARSE.indexOf("private"));
        } else if (associationClassPARSE.contains("protected")) {
            associationClassYAMLO.addStringToMap("visibility", "protected");
            associationClassPARSE.remove(associationClassPARSE.indexOf("protected"));
        }
        for (String string : associationClassPARSE) {
            if (!string.contains("<<") || !string.contains(">>")) continue;
            LinkedList<Character> targets = new LinkedList<Character>();
            targets.add(Character.valueOf('<'));
            targets.add(Character.valueOf('>'));
            String str2 = YamlUtil.removeMultiChar(string, targets);
            targets = new LinkedList();
            targets.add(Character.valueOf(' '));
            targets.add(Character.valueOf(','));
            List<String> list = YamlUtil.multiCharParse(str2, targets);
            for (String str3 : list) {
                associationClassYAMLO.addStringToMap("stereotypes", str3);
            }
        }
        if (associationClassPARSE.size() > 0) {
            String name = associationClassPARSE.get(0);
            associationClassYAMLO.addStringToMap("name", name);
            this.importsI.put(name, this.packageM + "." + name);
        }
        if (value instanceof Map) {
            if (((Map)value).containsKey("participant")) {
                if (((Map)value).get("participant") instanceof Map) {
                    for (Object object : ((Map)((Map)value).get("participant")).entrySet()) {
                        if (!(object instanceof Map.Entry)) continue;
                        List<String> participantPARSE = YamlUtil.charParse(String.valueOf(((Map.Entry)object).getKey()), Character.valueOf(' '));
                        YamlObject participantYAMLO = new YamlObject();
                        if (participantPARSE.contains("\"" + YamlUtil.extract(Character.valueOf('\"'), String.valueOf(((Map.Entry)object).getKey())) + "\"")) {
                            String label = YamlUtil.extract(Character.valueOf('\"'), String.valueOf(((Map.Entry)object).getKey()));
                            participantYAMLO.addStringToMap("label", label);
                            participantPARSE.remove("\"" + YamlUtil.extract(Character.valueOf('\"'), String.valueOf(((Map.Entry)object).getKey())) + "\"");
                        }
                        if (participantPARSE.size() > 0) {
                            participantYAMLO.addStringToMap("name", participantPARSE.get(0));
                        }
                        if (participantPARSE.size() > 1) {
                            participantYAMLO.addStringToMap("attribute", participantPARSE.get(1));
                        }
                        associationClassYAMLO.addYamlObjectToMap("participant", participantYAMLO);
                    }
                }
                ((Map)value).remove("participant");
            }
            for (Object object : ((Map)value).entrySet()) {
                if (!(object instanceof Map.Entry)) continue;
                String keyP = String.valueOf(((Map.Entry)object).getKey());
                Object valueP = ((Map.Entry)object).getValue();
                if (keyP.equals("superclasses")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superClass : (List)valueP) {
                        associationClassYAMLO.addStringToMap("superclasses", String.valueOf(superClass));
                    }
                    continue;
                }
                if (keyP.equals("superinterfaces")) {
                    if (!(valueP instanceof List)) continue;
                    for (Object superInterface : (List)valueP) {
                        associationClassYAMLO.addStringToMap("superinterfaces", String.valueOf(superInterface));
                    }
                    continue;
                }
                if (keyP.contains("(") && keyP.contains(")")) {
                    YamlObject operationYAMLO = new YamlObject();
                    this.parseOperation(keyP, valueP, operationYAMLO);
                    associationClassYAMLO.addYamlObjectToMap("operation", operationYAMLO);
                    continue;
                }
                YamlObject attributeYAMLO = new YamlObject();
                this.parseAttribute(keyP, valueP, attributeYAMLO);
                associationClassYAMLO.addYamlObjectToMap("attribute", attributeYAMLO);
            }
        }
    }

    public void parseEnumeration(String key, Object value, YamlObject enumerationYAMLO) {
        List<String> enumerationPARSE = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'));
        if (enumerationPARSE.contains("enumeration")) {
            enumerationPARSE.remove(enumerationPARSE.indexOf("enumeration"));
        }
        if (enumerationPARSE.contains("static")) {
            enumerationYAMLO.addStringToMap("static", String.valueOf(true));
            enumerationPARSE.remove(enumerationPARSE.indexOf("static"));
        }
        for (String string : enumerationPARSE) {
            if (!string.contains("<<") || !string.contains(">>")) continue;
            LinkedList<Character> targets = new LinkedList<Character>();
            targets.add(Character.valueOf('<'));
            targets.add(Character.valueOf('>'));
            String str2 = YamlUtil.removeMultiChar(string, targets);
            targets = new LinkedList();
            targets.add(Character.valueOf(' '));
            targets.add(Character.valueOf(','));
            List<String> list = YamlUtil.multiCharParse(str2, targets);
            for (String str3 : list) {
                enumerationYAMLO.addStringToMap("stereotypes", str3);
            }
        }
        if (enumerationPARSE.size() > 0) {
            String name = enumerationPARSE.get(0);
            enumerationYAMLO.addStringToMap("name", name);
            this.importsI.put(name, this.packageM + "." + name);
        }
        if (value instanceof Map && ((Map)value).containsKey("literals")) {
            if (((Map)value).get("literals") instanceof Map) {
                for (Object object : ((Map)((Map)value).get("literals")).entrySet()) {
                    if (!(object instanceof Map.Entry)) continue;
                    enumerationYAMLO.addStringToMap("literals", String.valueOf(((Map.Entry)object).getKey()));
                }
            }
            ((Map)value).remove("literals");
        }
    }

    public void parseAttribute(String key, Object value, YamlObject attributeYAMLO) {
        List<String> attributePARSE = YamlUtil.charParseIgnore(key, Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>'));
        if (attributePARSE.contains("composite")) {
            attributeYAMLO.addStringToMap("associationtype", "composite");
            attributePARSE.remove(attributePARSE.indexOf("composite"));
        } else if (attributePARSE.contains("aggregate")) {
            attributeYAMLO.addStringToMap("associationtype", "aggregate");
            attributePARSE.remove(attributePARSE.indexOf("aggregate"));
        }
        if (attributePARSE.contains("static")) {
            attributeYAMLO.addStringToMap("static", String.valueOf(true));
            attributePARSE.remove(attributePARSE.indexOf("static"));
        }
        if (attributePARSE.contains("final")) {
            attributeYAMLO.addStringToMap("final", String.valueOf(true));
            attributePARSE.remove(attributePARSE.indexOf("final"));
        }
        if (attributePARSE.contains("unique")) {
            attributeYAMLO.addStringToMap("unique", String.valueOf(true));
            attributePARSE.remove(attributePARSE.indexOf("unique"));
        }
        if (attributePARSE.contains("navigable")) {
            attributeYAMLO.addStringToMap("navigable", String.valueOf(true));
            attributePARSE.remove(attributePARSE.indexOf("navigable"));
        }
        if (attributePARSE.contains("transient")) {
            attributeYAMLO.addStringToMap("transient", String.valueOf(true));
            attributePARSE.remove(attributePARSE.indexOf("transient"));
        }
        if (attributePARSE.contains("public")) {
            attributeYAMLO.addStringToMap("visibility", "public");
            attributePARSE.remove(attributePARSE.indexOf("public"));
        } else if (attributePARSE.contains("protected")) {
            attributeYAMLO.addStringToMap("visibility", "protected");
            attributePARSE.remove(attributePARSE.indexOf("public"));
        } else if (attributePARSE.contains("private")) {
            attributeYAMLO.addStringToMap("visibility", "private");
            attributePARSE.remove(attributePARSE.indexOf("public"));
        }
        if (attributePARSE.contains("ordered")) {
            attributeYAMLO.addStringToMap("ordering", "ordered");
            attributePARSE.remove(attributePARSE.indexOf("ordered"));
        } else if (attributePARSE.contains("unordered")) {
            attributeYAMLO.addStringToMap("ordering", "unordered");
            attributePARSE.remove(attributePARSE.indexOf("unordered"));
        }
        if (attributePARSE.contains("\"" + YamlUtil.extract(Character.valueOf('\"'), key) + "\"")) {
            String label = YamlUtil.extract(Character.valueOf('\"'), key);
            attributeYAMLO.addStringToMap("label", label);
            attributePARSE.remove("\"" + YamlUtil.extract(Character.valueOf('\"'), key) + "\"");
        }
        if (attributePARSE.contains("[" + YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), key) + "]")) {
            String multiplicity = YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), key);
            if (multiplicity.equals("*")) {
                attributeYAMLO.addStringToMap("minmultiplicity", "0");
                attributeYAMLO.addStringToMap("maxmultiplicity", "-1");
            } else if (multiplicity.contains("..")) {
                String min = YamlUtil.beforeChar(multiplicity, Character.valueOf('.'));
                String max = YamlUtil.afterChar(multiplicity, Character.valueOf('.'));
                if (min.equals("*")) {
                    min = "-1";
                }
                if (max.equals("*")) {
                    max = "-1";
                }
                attributeYAMLO.addStringToMap("minmultiplicity", min);
                attributeYAMLO.addStringToMap("maxmultiplicity", max);
            }
            attributePARSE.remove("[" + YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), key) + "]");
        }
        if (attributePARSE.size() > 0) {
            attributeYAMLO.addStringToMap("type", attributePARSE.get(0));
        }
        if (attributePARSE.size() > 1) {
            attributeYAMLO.addStringToMap("name", attributePARSE.get(1));
        }
        if (value != null) {
            List<String> valuePARSE = YamlUtil.charParse(String.valueOf(value), Character.valueOf(' '));
            if (valuePARSE.contains("ordered")) {
                attributeYAMLO.addStringToMap("reverseordering", "ordered");
                attributePARSE.remove(valuePARSE.indexOf("ordered"));
            } else if (valuePARSE.contains("unordered")) {
                attributeYAMLO.addStringToMap("reverseordering", "unordered");
                attributePARSE.remove(valuePARSE.indexOf("unordered"));
            }
            if (valuePARSE.contains("[" + YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), String.valueOf(value)) + "]")) {
                String multiplicity = YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), String.valueOf(value));
                if (multiplicity.equals("*")) {
                    attributeYAMLO.addStringToMap("reverseminmultiplicity", "0");
                    attributeYAMLO.addStringToMap("reversemaxmultiplicity", "-1");
                } else if (multiplicity.contains("..")) {
                    String min = YamlUtil.beforeChar(multiplicity, Character.valueOf('.'));
                    String max = YamlUtil.afterChar(multiplicity, Character.valueOf('.'));
                    if (min.equals("*")) {
                        min = "-1";
                    }
                    if (max.equals("*")) {
                        max = "-1";
                    }
                    attributeYAMLO.addStringToMap("reverseminmultiplicity", min);
                    attributeYAMLO.addStringToMap("reversemaxmultiplicity", max);
                }
                valuePARSE.remove("[" + YamlUtil.extract(Character.valueOf('['), Character.valueOf(']'), String.valueOf(value)) + "]");
            }
        }
    }

    public void parseOperation(String key, Object value, YamlObject operationYAMLO) {
        LinkedList<Character> ignoreStart = new LinkedList<Character>();
        ignoreStart.add(Character.valueOf('('));
        ignoreStart.add(Character.valueOf('<'));
        LinkedList<Character> ignoreEnd = new LinkedList<Character>();
        ignoreEnd.add(Character.valueOf(')'));
        ignoreEnd.add(Character.valueOf('>'));
        List<String> operationPARSE = YamlUtil.charParseMultiIgnore(key, Character.valueOf(' '), ignoreStart, ignoreEnd);
        if (operationPARSE.contains("static")) {
            operationYAMLO.addStringToMap("static", String.valueOf(true));
            operationPARSE.remove(operationPARSE.indexOf("static"));
        }
        if (operationPARSE.contains("abstract")) {
            operationYAMLO.addStringToMap("abstract", String.valueOf(true));
            operationPARSE.remove(operationPARSE.indexOf("abstract"));
        }
        if (operationPARSE.contains("public")) {
            operationYAMLO.addStringToMap("visibility", "public");
            operationPARSE.remove(operationPARSE.indexOf("public"));
        } else if (operationPARSE.contains("protected")) {
            operationYAMLO.addStringToMap("visibility", "protected");
            operationPARSE.remove(operationPARSE.indexOf("protected"));
        } else if (operationPARSE.contains("private")) {
            operationYAMLO.addStringToMap("visibility", "private");
            operationPARSE.remove(operationPARSE.indexOf("private"));
        }
        for (String str1 : operationPARSE) {
            if (!str1.contains("(") || !str1.contains(")")) continue;
            operationYAMLO.addStringToMap("name", YamlUtil.beforeChar(str1, Character.valueOf('(')));
            for (String str2 : YamlUtil.charParseIgnore(YamlUtil.extract(Character.valueOf('('), Character.valueOf(')'), str1), Character.valueOf(','), Character.valueOf('<'), Character.valueOf('>'))) {
                List<String> list = YamlUtil.charParse(str2, Character.valueOf(' '));
                if (list.size() != 2) continue;
                YamlObject parameterYAMLO = new YamlObject();
                parameterYAMLO.addStringToMap("type", list.get(0));
                parameterYAMLO.addStringToMap("name", list.get(1));
                operationYAMLO.addYamlObjectToMap("parameter", parameterYAMLO);
            }
        }
        if (operationPARSE.size() > 1) {
            YamlObject returnParameterYAMLO = new YamlObject();
            returnParameterYAMLO.addStringToMap("type", operationPARSE.get(0));
            operationYAMLO.addYamlObjectToMap("returnparameter", returnParameterYAMLO);
        }
        if (value != null) {
            operationYAMLO.addStringToMap("bodeycode", String.valueOf(value));
        }
    }

    public void resolveImports() {
        this.imports.putAll(this.importsE);
        this.imports.putAll(this.importsI);
        for (Map.Entry<String, List<YamlObject>> entry : this.modelYAMLO.getMapStringListYamlObject().entrySet()) {
            for (YamlObject importable : entry.getValue()) {
                if (importable.containsKeyMapStringListString("superclasses")) {
                    for (String value : importable.getMapStringListString("superclasses")) {
                        if (!this.imports.containsKey(value)) continue;
                        importable.setMapStringListString("superclasses", value, this.imports.get(value));
                    }
                }
                if (importable.containsKeyMapStringListString("superinterfaces")) {
                    for (String value : importable.getMapStringListString("superinterfaces")) {
                        if (!this.imports.containsKey(value)) continue;
                        importable.setMapStringListString("superinterfaces", value, this.imports.get(value));
                    }
                }
                if (importable.containsKeyYamlMapStringListYamlObject("attribute")) {
                    for (YamlObject attributeYAMLO : importable.getMapStringListYamlObject("attribute")) {
                        if (!attributeYAMLO.containsKeyMapStringListString("type")) continue;
                        attributeYAMLO.setMapStringListString("type", attributeYAMLO.getFirstMapStringListString("type"), this.resolveType(attributeYAMLO.getFirstMapStringListString("type")));
                    }
                }
                if (importable.containsKeyYamlMapStringListYamlObject("operation")) {
                    for (YamlObject operationYAMLO : importable.getMapStringListYamlObject("operation")) {
                        if (operationYAMLO.containsKeyYamlMapStringListYamlObject("parameter")) {
                            for (YamlObject parameterYAMLO : operationYAMLO.getMapStringListYamlObject("parameter")) {
                                if (!parameterYAMLO.containsKeyMapStringListString("type")) continue;
                                parameterYAMLO.setMapStringListString("type", parameterYAMLO.getFirstMapStringListString("type"), this.resolveType(parameterYAMLO.getFirstMapStringListString("type")));
                            }
                        }
                        if (!operationYAMLO.containsKeyYamlMapStringListYamlObject("returnparameter")) continue;
                        for (YamlObject parameterYAMLO : operationYAMLO.getMapStringListYamlObject("returnparameter")) {
                            if (!parameterYAMLO.containsKeyMapStringListString("type")) continue;
                            parameterYAMLO.setMapStringListString("type", parameterYAMLO.getFirstMapStringListString("type"), this.resolveType(parameterYAMLO.getFirstMapStringListString("type")));
                        }
                    }
                }
                if (!importable.containsKeyYamlMapStringListYamlObject("participant")) continue;
                for (YamlObject participantYAMLO : importable.getMapStringListYamlObject("participant")) {
                    if (!participantYAMLO.containsKeyMapStringListString("name")) continue;
                    participantYAMLO.setMapStringListString("name", participantYAMLO.getFirstMapStringListString("name"), this.resolveType(participantYAMLO.getFirstMapStringListString("name")));
                }
            }
        }
    }

    public String browseType(String type) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        for (String tmp : YamlUtil.charParseIgnore(type, Character.valueOf(','), Character.valueOf('<'), Character.valueOf('>'))) {
            if (first) {
                first = false;
            } else {
                res.append(",");
            }
            if (tmp.contains("<") && tmp.contains(">")) {
                String ninja = YamlUtil.beforeChar(tmp, Character.valueOf('<'));
                if (this.imports.containsKey(ninja)) {
                    res.append(this.imports.get(ninja));
                } else {
                    res.append(ninja);
                }
                res.append("<");
                res.append(this.browseType(YamlUtil.extract(Character.valueOf('<'), Character.valueOf('>'), tmp)));
                res.append(">");
                continue;
            }
            if (this.imports.containsKey(tmp)) {
                res.append(this.imports.get(tmp));
                continue;
            }
            res.append(tmp);
        }
        return res.toString();
    }

    public String resolveType(String type) {
        LinkedList<Character> ignore = new LinkedList<Character>();
        ignore.add(Character.valueOf(' '));
        String typePARSE = YamlUtil.removeMultiChar(type, ignore);
        return this.browseType(typePARSE);
    }

    public void resolveLabels() {
        for (List<YamlObject> objectYAMLO : this.modelYAMLO.getMapStringListYamlObject().values()) {
            for (YamlObject labelisable : objectYAMLO) {
                YamlObject reverseAttribute;
                String label;
                if (labelisable.containsKeyYamlMapStringListYamlObject("attribute")) {
                    for (YamlObject attribute : labelisable.getMapStringListYamlObject("attribute")) {
                        String type;
                        if (!attribute.containsKeyMapStringListString("type") || !this.importsI.containsValue(type = attribute.getFirstMapStringListString("type")) || attribute.containsKeyMapStringListString("navigable")) continue;
                        if (attribute.containsKeyMapStringListString("label")) {
                            label = attribute.getFirstMapStringListString("label");
                            reverseAttribute = this.getReverseAttribute(YamlUtil.afterChar(type, Character.valueOf('.')), label);
                            if (reverseAttribute == null) continue;
                            attribute.addStringToMap("navigable", String.valueOf(true));
                            reverseAttribute.addStringToMap("navigable", String.valueOf(true));
                            if (attribute.containsKeyMapStringListString("maxmultiplicity")) {
                                reverseAttribute.addStringToMap("reversemaxmultiplicity", attribute.getFirstMapStringListString("maxmultiplicity"));
                            }
                            if (reverseAttribute.containsKeyMapStringListString("maxmultiplicity")) {
                                attribute.addStringToMap("reversemaxmultiplicity", reverseAttribute.getFirstMapStringListString("maxmultiplicity"));
                            }
                            if (attribute.containsKeyMapStringListString("name")) {
                                reverseAttribute.addStringToMap("reverseattributename", attribute.getFirstMapStringListString("name"));
                            }
                            if (!reverseAttribute.containsKeyMapStringListString("name")) continue;
                            attribute.addStringToMap("reverseattributename", reverseAttribute.getFirstMapStringListString("name"));
                            continue;
                        }
                        YamlObject reverseObject = this.getReverseObject(YamlUtil.afterChar(type, Character.valueOf('.')));
                        if (reverseObject == null) continue;
                        reverseAttribute = new YamlObject();
                        attribute.addStringToMap("navigable", String.valueOf(true));
                        reverseAttribute.addStringToMap("navigable", String.valueOf(false));
                        reverseAttribute.addStringToMap("type", this.imports.get(labelisable.getFirstMapStringListString("name")));
                        if (attribute.containsKeyMapStringListString("maxmultiplicity")) {
                            reverseAttribute.addStringToMap("reversemaxmultiplicity", attribute.getFirstMapStringListString("maxmultiplicity"));
                        }
                        if (attribute.containsKeyMapStringListString("name")) {
                            reverseAttribute.addStringToMap("reverseattributename", attribute.getFirstMapStringListString("name"));
                        }
                        if (attribute.containsKeyMapStringListString("reverseminmultiplicity")) {
                            reverseAttribute.addStringToMap("minmultiplicity", attribute.getFirstMapStringListString("reverseminmultiplicity"));
                        }
                        if (attribute.containsKeyMapStringListString("reversemaxmultiplicity")) {
                            reverseAttribute.addStringToMap("maxmultiplicity", attribute.getFirstMapStringListString("reversemaxmultiplicity"));
                        }
                        if (attribute.containsKeyMapStringListString("reverseordering")) {
                            reverseAttribute.addStringToMap("ordering", attribute.getFirstMapStringListString("reverseordering"));
                        } else if (attribute.containsKeyMapStringListString("ordering")) {
                            if (attribute.getFirstMapStringListString("ordering").equals("ordered")) {
                                reverseAttribute.addStringToMap("ordering", "unordered");
                            } else if (attribute.getFirstMapStringListString("ordering").equals("unordered")) {
                                reverseAttribute.addStringToMap("ordering", "ordered");
                            }
                        }
                        reverseObject.addYamlObjectToMap("attribute", reverseAttribute);
                    }
                }
                if (!labelisable.containsKeyYamlMapStringListYamlObject("participant")) continue;
                for (YamlObject participant : labelisable.getMapStringListYamlObject("participant")) {
                    String name;
                    if (!participant.containsKeyMapStringListString("name") || !this.importsI.containsValue(name = participant.getFirstMapStringListString("name")) || !participant.containsKeyMapStringListString("label")) continue;
                    label = participant.getFirstMapStringListString("label");
                    reverseAttribute = this.getReverseAttribute(YamlUtil.afterChar(name, Character.valueOf('.')), label);
                    if (reverseAttribute == null || !labelisable.containsKeyMapStringListString("name")) continue;
                    reverseAttribute.addStringToMap("associationclassname", this.packageM + "." + labelisable.getFirstMapStringListString("name"));
                }
            }
        }
    }

    public YamlObject getReverseAttribute(String type, String label) {
        for (List<YamlObject> objectsYAMLO : this.modelYAMLO.getMapStringListYamlObject().values()) {
            for (YamlObject objectYAMLO : objectsYAMLO) {
                String name;
                if (!objectYAMLO.containsKeyMapStringListString("name") || !(name = objectYAMLO.getFirstMapStringListString("name")).equals(type) || !objectYAMLO.containsKeyYamlMapStringListYamlObject("attribute")) continue;
                for (YamlObject attributeYAMLO : objectYAMLO.getMapStringListYamlObject("attribute")) {
                    String reverseLabel;
                    if (!attributeYAMLO.containsKeyMapStringListString("label") || !(reverseLabel = attributeYAMLO.getFirstMapStringListString("label")).equals(label)) continue;
                    return attributeYAMLO;
                }
            }
        }
        return null;
    }

    public YamlObject getReverseObject(String type) {
        for (List<YamlObject> objectsYAMLO : this.modelYAMLO.getMapStringListYamlObject().values()) {
            for (YamlObject objectYAMLO : objectsYAMLO) {
                String name;
                if (!objectYAMLO.containsKeyMapStringListString("name") || !(name = objectYAMLO.getFirstMapStringListString("name")).equals(type)) continue;
                return objectYAMLO;
            }
        }
        return null;
    }
}

