/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.reader.yaml.DefaultValues;
import org.nuiton.eugene.models.object.reader.yaml.KeyWords;
import org.nuiton.eugene.models.object.reader.yaml.LoadObjectModel;
import org.nuiton.eugene.models.object.reader.yaml.SyntaxePureYaml;
import org.nuiton.eugene.models.object.reader.yaml.SyntaxeUserFriendly;
import org.nuiton.eugene.models.object.reader.yaml.YamlObject;
import org.nuiton.eugene.models.object.reader.yaml.YamlUtil;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.yaml.snakeyaml.Yaml;

public class LoadYamlFile
implements KeyWords {
    Yaml yaml = new Yaml();

    public void loadFile(File file, ObjectModel model) throws IOException {
        FileInputStream inputModel = new FileInputStream(file);
        Object modelYAML = this.yaml.load((InputStream)inputModel);
        ((InputStream)inputModel).close();
        ObjectModelImpl modelOM = (ObjectModelImpl)model;
        YamlObject modelYAMLO = new YamlObject();
        Object version = null;
        String syntaxeVersion = "0";
        String defaultVersion = "0";
        if (modelYAML instanceof List) {
            version = YamlUtil.collectElementList((List)modelYAML, "syntaxe");
            syntaxeVersion = "1";
            defaultVersion = "0";
        } else if (modelYAML instanceof Map) {
            version = YamlUtil.collectElementMap((Map)modelYAML, "syntaxe");
            syntaxeVersion = "2";
            defaultVersion = "0";
        }
        if (version != null) {
            syntaxeVersion = YamlUtil.beforeChar(String.valueOf(version), Character.valueOf('.'));
            defaultVersion = YamlUtil.afterChar(String.valueOf(version), Character.valueOf('.'));
        }
        if (syntaxeVersion.equals("1")) {
            SyntaxePureYaml.loadYamlObject(modelYAML, modelYAMLO);
        } else if (syntaxeVersion.equals("2")) {
            SyntaxeUserFriendly.loadYamlObject(modelYAML, modelYAMLO);
        }
        LoadObjectModel loader = new LoadObjectModel(modelYAMLO, modelOM, DefaultValues.getDefaultValues(defaultVersion));
        loader.loadModel();
    }
}

