/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader.yaml;

import java.util.List;
import java.util.Map;
import org.nuiton.eugene.models.object.reader.yaml.KeyWords;
import org.nuiton.eugene.models.object.reader.yaml.YamlObject;
import org.nuiton.eugene.models.object.xml.ObjectModeImplAssociationClassParticipant;
import org.nuiton.eugene.models.object.xml.ObjectModelAssociationClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplSuperClassRef;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class LoadObjectModel
implements KeyWords {
    protected String packageL = "default";
    protected YamlObject modelYAMLO;
    protected ObjectModelImpl modelOM;
    protected Map<String, String> defaultValues;

    public LoadObjectModel(YamlObject modelYAMLO, ObjectModelImpl modelOM, Map<String, String> defaultValues) {
        this.modelOM = modelOM;
        this.modelYAMLO = modelYAMLO;
        this.defaultValues = defaultValues;
    }

    public void loadModel() {
        String packageYAMLO = this.modelYAMLO.getFirstMapStringListString("package");
        if (packageYAMLO == null) {
            String key = "package";
            if (this.defaultValues.containsKey(key)) {
                this.packageL = this.defaultValues.get(key);
            }
        } else {
            this.packageL = packageYAMLO;
        }
        this.modelOM.addTagValue("package", this.packageL);
        String nameYAMLO = this.modelYAMLO.getFirstMapStringListString("name");
        if (nameYAMLO == null) {
            String key = "name";
            if (this.defaultValues.containsKey(key)) {
                this.modelOM.setName(this.defaultValues.get(key));
            }
        } else {
            this.modelOM.setName(nameYAMLO);
        }
        String versionYAMLO = this.modelYAMLO.getFirstMapStringListString("version");
        if (versionYAMLO == null) {
            String key = "version";
            if (this.defaultValues.containsKey(key)) {
                this.modelOM.setVersion(this.defaultValues.get(key));
            }
        } else {
            this.modelOM.setVersion(versionYAMLO);
        }
        YamlObject tagValues = this.modelYAMLO.getFirstMapStringListYamlObject("tagvalues");
        if (tagValues != null) {
            for (Map.Entry entry : tagValues.getMapStringListString().entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                this.modelOM.addTagValue((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
        }
        for (YamlObject yamlObject : this.modelYAMLO.getMapStringListYamlObject("class")) {
            ObjectModelClassImpl classOM = new ObjectModelClassImpl();
            this.loadClass(yamlObject, classOM);
            this.modelOM.addClass(classOM);
        }
        for (YamlObject yamlObject : this.modelYAMLO.getMapStringListYamlObject("interface")) {
            ObjectModelInterfaceImpl interfaceOM = new ObjectModelInterfaceImpl();
            this.loadInterface(yamlObject, interfaceOM);
            this.modelOM.addInterface(interfaceOM);
        }
        for (YamlObject yamlObject : this.modelYAMLO.getMapStringListYamlObject("associationclass")) {
            ObjectModelAssociationClassImpl associationClassOM = new ObjectModelAssociationClassImpl();
            this.loadAssociationClass(yamlObject, associationClassOM);
            this.modelOM.addAssociationClass(associationClassOM);
        }
        for (YamlObject yamlObject : this.modelYAMLO.getMapStringListYamlObject("enumeration")) {
            ObjectModelEnumerationImpl enumerationOM = new ObjectModelEnumerationImpl();
            this.loadEnumeration(yamlObject, enumerationOM);
            this.modelOM.addEnumeration(enumerationOM);
        }
    }

    public void loadElement(YamlObject elementYAMLO, ObjectModelElementImpl elementOM) {
        String nameYAMLO = elementYAMLO.getFirstMapStringListString("name");
        if (nameYAMLO == null) {
            String key = "element.name";
            if (this.defaultValues.containsKey(key)) {
                elementOM.setName(this.defaultValues.get(key));
            }
        } else {
            elementOM.setName(nameYAMLO);
        }
        String staticYAMLO = elementYAMLO.getFirstMapStringListString("static");
        if (staticYAMLO == null) {
            String key = "element.static";
            if (this.defaultValues.containsKey(key)) {
                elementOM.setStatic(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            elementOM.setStatic(Boolean.valueOf(staticYAMLO));
        }
        String documentationYAMLO = elementYAMLO.getFirstMapStringListString("documentation");
        if (documentationYAMLO == null) {
            String key = "element.documentation";
            if (this.defaultValues.containsKey(key)) {
                elementOM.setDocumentation(this.defaultValues.get(key));
            }
        } else {
            elementOM.setDocumentation(documentationYAMLO);
        }
        YamlObject tagValues = elementYAMLO.getFirstMapStringListYamlObject("tagvalues");
        if (tagValues != null) {
            for (Map.Entry<String, List<String>> tagValue : tagValues.getMapStringListString().entrySet()) {
                if (((List)tagValue.getValue()).isEmpty()) continue;
                elementOM.addTagValue((String)tagValue.getKey(), (String)((List)tagValue.getValue()).get(0));
            }
        }
        List<String> comments = elementYAMLO.getMapStringListString("comments");
        for (String comment : comments) {
            elementOM.addComment(comment);
        }
        List<String> stereotypes = elementYAMLO.getMapStringListString("stereotypes");
        for (String stereotype : stereotypes) {
            ObjectModelImplRef stereotypeOM = new ObjectModelImplRef();
            stereotypeOM.setName(stereotype);
            elementOM.addStereotype(stereotypeOM);
        }
    }

    public void loadClassifier(YamlObject classifierYAMLO, ObjectModelClassifierImpl classifierOM) {
        this.loadElement(classifierYAMLO, classifierOM);
        String packageYAMLO = classifierYAMLO.getFirstMapStringListString("package");
        if (packageYAMLO == null) {
            classifierOM.setPackage(this.packageL);
        } else {
            classifierOM.setPackage(packageYAMLO);
        }
        String externYAMLO = classifierYAMLO.getFirstMapStringListString("extern");
        if (externYAMLO == null) {
            String key = "classifier.extern";
            if (this.defaultValues.containsKey(key)) {
                classifierOM.setExtern(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            classifierOM.setExtern(Boolean.valueOf(externYAMLO));
        }
        String innerYAMLO = classifierYAMLO.getFirstMapStringListString("inner");
        if (innerYAMLO == null) {
            String key = "classifier.inner";
            if (this.defaultValues.containsKey(key)) {
                classifierOM.setInner(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            classifierOM.setInner(Boolean.valueOf(innerYAMLO));
        }
        String typeYAMLO = classifierYAMLO.getFirstMapStringListString("type");
        if (typeYAMLO == null) {
            String key = "classifier.type";
            if (this.defaultValues.containsKey(key)) {
                classifierOM.setType(this.defaultValues.get(key));
            }
        } else {
            classifierOM.setType(typeYAMLO);
        }
        for (YamlObject attributeYAMLO : classifierYAMLO.getMapStringListYamlObject("attribute")) {
            ObjectModelAttributeImpl attributeOM = new ObjectModelAttributeImpl();
            this.loadAttribute(attributeYAMLO, attributeOM);
            classifierOM.addAttribute(attributeOM);
        }
        for (YamlObject operationYAMLO : classifierYAMLO.getMapStringListYamlObject("operation")) {
            ObjectModelOperationImpl operationOM = new ObjectModelOperationImpl();
            this.loadOperation(operationYAMLO, operationOM);
            classifierOM.addOperation(operationOM);
        }
        List<String> superInterfacesYAMLO = classifierYAMLO.getMapStringListString("superinterfaces");
        for (String superInterfaceYAMLO : superInterfacesYAMLO) {
            ObjectModelImplRef superInterfaceOM = new ObjectModelImplRef();
            superInterfaceOM.setName(superInterfaceYAMLO);
            classifierOM.addInterface(superInterfaceOM);
        }
    }

    public void loadClass(YamlObject classYAMLO, ObjectModelClassImpl classOM) {
        this.loadClassifier(classYAMLO, classOM);
        String abstractYAMLO = classYAMLO.getFirstMapStringListString("abstract");
        if (abstractYAMLO == null) {
            String key = "class.abstract";
            if (this.defaultValues.containsKey(key)) {
                classOM.setAbstract(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            classOM.setAbstract(Boolean.valueOf(abstractYAMLO));
        }
        List<String> superClassesYAMLO = classYAMLO.getMapStringListString("superclasses");
        for (String superClassYAMLO : superClassesYAMLO) {
            ObjectModelImplSuperClassRef superClassOM = new ObjectModelImplSuperClassRef();
            superClassOM.setName(superClassYAMLO);
            classOM.addSuperclass(superClassOM);
        }
    }

    public void loadInterface(YamlObject interfaceYAMLO, ObjectModelInterfaceImpl interfaceOM) {
        this.loadClassifier(interfaceYAMLO, interfaceOM);
    }

    public void loadAssociationClass(YamlObject associationClassYAML, ObjectModelAssociationClassImpl associationClassOM) {
        this.loadClass(associationClassYAML, associationClassOM);
        for (YamlObject participantYAMLO : associationClassYAML.getMapStringListYamlObject("participant")) {
            ObjectModeImplAssociationClassParticipant participantOM = new ObjectModeImplAssociationClassParticipant();
            participantOM.setAssociationClass(associationClassOM);
            String nameYAMLO = participantYAMLO.getFirstMapStringListString("name");
            if (nameYAMLO == null) {
                String key = "associationclass.participant.name";
                if (this.defaultValues.containsKey(key)) {
                    participantOM.setName(this.defaultValues.get(key));
                }
            } else {
                participantOM.setName(nameYAMLO);
            }
            String attributeYAMLO = participantYAMLO.getFirstMapStringListString("attribute");
            if (attributeYAMLO == null) {
                String key = "associationclass.participant.attribute";
                if (this.defaultValues.containsKey(key)) {
                    participantOM.setAttribute(this.defaultValues.get(key));
                }
            } else {
                participantOM.setAttribute(attributeYAMLO);
            }
            associationClassOM.addParticipant(participantOM);
        }
    }

    public void loadEnumeration(YamlObject enumerationYAMLO, ObjectModelEnumerationImpl enumerationOM) {
        this.loadElement(enumerationYAMLO, enumerationOM);
        List<String> literalsYAMLO = enumerationYAMLO.getMapStringListString("literals");
        for (String literalYAMLO : literalsYAMLO) {
            ObjectModelImplRef literalOM = new ObjectModelImplRef();
            literalOM.setName(literalYAMLO);
            enumerationOM.addLiteral(literalOM);
        }
        String packageYAMLO = enumerationYAMLO.getFirstMapStringListString("package");
        if (packageYAMLO == null) {
            enumerationOM.setPackage(this.packageL);
        } else {
            enumerationOM.setPackage(packageYAMLO);
        }
    }

    public void loadParameter(YamlObject parameterYAMLO, ObjectModelParameterImpl parameterOM) {
        this.loadElement(parameterYAMLO, parameterOM);
        String orderingYAMLO = parameterYAMLO.getFirstMapStringListString("ordering");
        if (orderingYAMLO == null) {
            String key = "parameter.ordering";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setOrdering(this.defaultValues.get(key));
            }
        } else {
            parameterOM.setOrdering(orderingYAMLO);
        }
        String typeYAMLO = parameterYAMLO.getFirstMapStringListString("type");
        if (typeYAMLO == null) {
            String key = "parameter.type";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setType(this.defaultValues.get(key));
            }
        } else {
            parameterOM.setType(typeYAMLO);
        }
        String defaultValueYAMLO = parameterYAMLO.getFirstMapStringListString("defaultvalue");
        if (defaultValueYAMLO == null) {
            String key = "parameter.defaultvalue";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setDefaultValue(this.defaultValues.get(key));
            }
        } else {
            parameterOM.setDefaultValue(defaultValueYAMLO);
        }
        String minMultiplicityYAMLO = parameterYAMLO.getFirstMapStringListString("minmultiplicity");
        if (minMultiplicityYAMLO == null) {
            String key = "parameter.minmultiplicity";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setMinMultiplicity(Integer.valueOf(this.defaultValues.get(key)));
            }
        } else {
            parameterOM.setMinMultiplicity(Integer.valueOf(minMultiplicityYAMLO));
        }
        String maxMultiplicityYAMLO = parameterYAMLO.getFirstMapStringListString("maxmultiplicity");
        if (maxMultiplicityYAMLO == null) {
            String key = "parameter.maxmultiplicity";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setMaxMultiplicity(Integer.valueOf(this.defaultValues.get(key)));
            }
        } else {
            parameterOM.setMaxMultiplicity(Integer.valueOf(maxMultiplicityYAMLO));
        }
        String orderedYAMLO = parameterYAMLO.getFirstMapStringListString("ordered");
        if (orderedYAMLO == null) {
            String key = "parameter.ordered";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setOrdered(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            parameterOM.setOrdered(Boolean.valueOf(orderedYAMLO));
        }
        String uniqueYAMLO = parameterYAMLO.getFirstMapStringListString("unique");
        if (uniqueYAMLO == null) {
            String key = "parameter.unique";
            if (this.defaultValues.containsKey(key)) {
                parameterOM.setUnique(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            parameterOM.setUnique(Boolean.valueOf(uniqueYAMLO));
        }
    }

    public void loadAttribute(YamlObject attributeYAMLO, ObjectModelAttributeImpl attributeOM) {
        this.loadParameter(attributeYAMLO, attributeOM);
        String navigableYAMLO = attributeYAMLO.getFirstMapStringListString("navigable");
        if (navigableYAMLO == null) {
            String key = "attribute.navigable";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setNavigable(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            attributeOM.setNavigable(Boolean.valueOf(navigableYAMLO));
        }
        String associationTypeYAMLO = attributeYAMLO.getFirstMapStringListString("associationtype");
        if (associationTypeYAMLO == null) {
            String key = "attribute.associationtype";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setAssociationType(this.defaultValues.get(key));
            }
        } else {
            attributeOM.setAssociationType(associationTypeYAMLO);
        }
        String finalYAMLO = attributeYAMLO.getFirstMapStringListString("final");
        if (finalYAMLO == null) {
            String key = "attribute.final";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setFinal(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            attributeOM.setFinal(Boolean.valueOf(finalYAMLO));
        }
        String staticYAMLO = attributeYAMLO.getFirstMapStringListString("static");
        if (staticYAMLO == null) {
            String key = "attribute.static";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setStatic(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            attributeOM.setStatic(Boolean.valueOf(staticYAMLO));
        }
        String associationClassNameYAMLO = attributeYAMLO.getFirstMapStringListString("associationclassname");
        if (associationClassNameYAMLO == null) {
            String key = "attribute.associationclassname";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setAssociationClassName(this.defaultValues.get(key));
            }
        } else {
            attributeOM.setAssociationClassName(associationClassNameYAMLO);
        }
        String reverseAttributeNameYAMLO = attributeYAMLO.getFirstMapStringListString("reverseattributename");
        if (reverseAttributeNameYAMLO == null) {
            String key = "attribute.reverseattributename";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setReverseAttributeName(this.defaultValues.get(key));
            }
        } else {
            attributeOM.setReverseAttributeName(reverseAttributeNameYAMLO);
        }
        String reverseMaxMultiplicityYAMLO = attributeYAMLO.getFirstMapStringListString("reversemaxmultiplicity");
        if (reverseMaxMultiplicityYAMLO == null) {
            String key = "attribute.reversemaxmultiplicity";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setReverseMaxMultiplicity(Integer.valueOf(this.defaultValues.get(key)));
            }
        } else {
            attributeOM.setReverseMaxMultiplicity(Integer.valueOf(reverseMaxMultiplicityYAMLO));
        }
        String transientYAMLO = attributeYAMLO.getFirstMapStringListString("transient");
        if (transientYAMLO == null) {
            String key = "attribute.transient";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setTransient(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            attributeOM.setTransient(Boolean.valueOf(transientYAMLO));
        }
        String visibilityYAMLO = attributeYAMLO.getFirstMapStringListString("visibility");
        if (visibilityYAMLO == null) {
            String key = "attribute.visibility";
            if (this.defaultValues.containsKey(key)) {
                attributeOM.setVisibility(this.defaultValues.get(key));
            }
        } else {
            attributeOM.setVisibility(visibilityYAMLO);
        }
    }

    public void loadOperation(YamlObject operationYAMLO, ObjectModelOperationImpl operationOM) {
        this.loadElement(operationYAMLO, operationOM);
        String abstractYAMLO = operationYAMLO.getFirstMapStringListString("abstract");
        if (abstractYAMLO == null) {
            String key = "operation.abstract";
            if (this.defaultValues.containsKey(key)) {
                operationOM.setAbstract(Boolean.valueOf(this.defaultValues.get(key)));
            }
        } else {
            operationOM.setAbstract(Boolean.valueOf(abstractYAMLO));
        }
        String visibilityYAMLO = operationYAMLO.getFirstMapStringListString("visibility");
        if (visibilityYAMLO == null) {
            String key = "operation.visibility";
            if (this.defaultValues.containsKey(key)) {
                operationOM.setVisibility(this.defaultValues.get(key));
            }
        } else {
            operationOM.setVisibility(visibilityYAMLO);
        }
        for (YamlObject returnParameterYAMLO : operationYAMLO.getMapStringListYamlObject("returnparameter")) {
            ObjectModelAttributeImpl returnParameterOM = new ObjectModelAttributeImpl();
            this.loadParameter(returnParameterYAMLO, returnParameterOM);
            operationOM.setReturnParameter(returnParameterOM);
        }
        for (YamlObject parameterYAMLO : operationYAMLO.getMapStringListYamlObject("parameter")) {
            ObjectModelAttributeImpl parameterOM = new ObjectModelAttributeImpl();
            this.loadParameter(parameterYAMLO, parameterOM);
            operationOM.addParameter(parameterOM);
        }
        String bodyCodeYAMLO = operationYAMLO.getFirstMapStringListString("bodeycode");
        if (bodyCodeYAMLO == null) {
            String key = "operation.bodeycode";
            if (this.defaultValues.containsKey(key)) {
                operationOM.setBodyCode(this.defaultValues.get(key));
            }
        } else {
            operationOM.setBodyCode(bodyCodeYAMLO);
        }
    }
}

