/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader;

import java.io.File;
import java.io.IOException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.RuleSet;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.reader.AbstractObjectModelReader;
import org.nuiton.eugene.models.object.xml.DigesterObjectModelRuleSet;
import org.xml.sax.SAXException;

@Component(role=ModelReader.class, hint="xmlobjectmodel")
public class XmlObjectModelReader
extends AbstractObjectModelReader {
    protected Digester digester;

    @Override
    public String getInputType() {
        return ModelHelper.ModelInputType.XML.getAlias();
    }

    @Override
    protected void beforeReadFile(File ... files) {
        super.beforeReadFile(files);
        this.digester = new Digester();
        this.digester.addRuleSet((RuleSet)new DigesterObjectModelRuleSet());
    }

    @Override
    protected void readFileToModel(File file, ObjectModel model) throws IOException {
        try {
            this.digester.push((Object)model);
            this.digester.parse(file);
        }
        catch (SAXException e) {
            throw new IOException("Unable to parse ObjectModel input file : " + file, e);
        }
    }
}

