/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object;

import io.ultreia.java4all.lang.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class SerialVersionUIDBuilder {
    protected ObjectModelClassifier clazz;
    protected List<String> interfaceSignatures;
    protected List<String> fieldSignatures;
    protected List<String> methodSignatures;

    public static long computeDefaultSUID(ObjectModelClassifier psiClass) {
        SerialVersionUIDBuilder builder = new SerialVersionUIDBuilder(psiClass);
        long result = builder.buildUID();
        return result;
    }

    public SerialVersionUIDBuilder(ObjectModelClassifier clazz) {
        StringBuilder sb;
        this.clazz = clazz;
        this.interfaceSignatures = new ArrayList<String>();
        for (ObjectModelInterface objectModelInterface : clazz.getInterfaces()) {
            this.interfaceSignatures.add(objectModelInterface.getQualifiedName());
        }
        Collections.sort(this.interfaceSignatures);
        if (clazz instanceof ObjectModelClass) {
            ObjectModelClass objectModelClass = (ObjectModelClass)clazz;
            for (ObjectModelClass modelClass : objectModelClass.getSuperclasses()) {
                this.interfaceSignatures.add(modelClass.getQualifiedName());
            }
        }
        this.methodSignatures = new ArrayList<String>();
        for (ObjectModelOperation objectModelOperation : clazz.getAllInterfaceOperations(true)) {
            sb = new StringBuilder();
            sb.append(objectModelOperation.getReturnType()).append(objectModelOperation.getName());
            for (ObjectModelParameter parameter : objectModelOperation.getParameters()) {
                sb.append(parameter.getType()).append(parameter.getName());
            }
            for (String exception : objectModelOperation.getExceptions()) {
                sb.append(exception);
            }
            this.methodSignatures.add(sb.toString());
        }
        Collections.sort(this.methodSignatures);
        this.fieldSignatures = new ArrayList<String>();
        for (ObjectModelAttribute objectModelAttribute : clazz.getAllInterfaceAttributes()) {
            sb = new StringBuilder();
            sb.append(objectModelAttribute.getType()).append(objectModelAttribute.getName());
            this.fieldSignatures.add(sb.toString());
        }
        Collections.sort(this.fieldSignatures);
    }

    public long buildUID() {
        StringBuilder sb = new StringBuilder();
        String className = this.clazz.getName();
        sb.append(className);
        for (String interfactSignature : this.getFieldSignatures()) {
            sb.append(interfactSignature);
        }
        for (String fieldSignature : this.getFieldSignatures()) {
            sb.append(fieldSignature);
        }
        for (String methodSignature : this.getMethodSignatures()) {
            sb.append(methodSignature);
        }
        byte[] digestBytes = Strings.encodeSHA1((String)sb.toString()).getBytes();
        long serialVersionUID = 0L;
        for (int i = Math.min(digestBytes.length, 8) - 1; i >= 0; --i) {
            serialVersionUID = serialVersionUID << 8 | (long)(digestBytes[i] & 0xFF);
        }
        return serialVersionUID;
    }

    public List<String> getInterfaceSignatures() {
        return this.interfaceSignatures;
    }

    public List<String> getFieldSignatures() {
        return this.fieldSignatures;
    }

    public List<String> getMethodSignatures() {
        return this.methodSignatures;
    }
}

