/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object;

import java.util.Collection;
import org.nuiton.eugene.Transformer;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelType;

public abstract class ObjectModelTransformer<O extends Model>
extends Transformer<ObjectModel, O> {
    @Override
    public void transform() {
        ObjectModel model = (ObjectModel)this.getModel();
        this.transformFromElement(model, ObjectModelType.OBJECT_MODEL);
        this.transformFromElements(model.getClassifiers(), ObjectModelType.OBJECT_MODEL_CLASSIFIER);
        this.transformFromElements(model.getInterfaces(), ObjectModelType.OBJECT_MODEL_INTERFACE);
        this.transformFromElements(model.getClasses(), ObjectModelType.OBJECT_MODEL_CLASS);
        this.transformFromElements(model.getEnumerations(), ObjectModelType.OBJECT_MODEL_ENUMERATION);
        this.debugOutputModel();
    }

    protected abstract void debugOutputModel();

    private void transformFromElements(Collection<? extends ObjectModelElement> elements, ObjectModelType type) {
        for (ObjectModelElement objectModelElement : elements) {
            this.transformFromElement(objectModelElement, type);
        }
    }

    protected void transformFromElement(Object element, ObjectModelType type) {
        switch (type) {
            case OBJECT_MODEL: {
                this.transformFromModel((ObjectModel)element);
                break;
            }
            case OBJECT_MODEL_CLASSIFIER: {
                this.transformFromClassifier((ObjectModelClassifier)element);
                break;
            }
            case OBJECT_MODEL_INTERFACE: {
                this.transformFromInterface((ObjectModelInterface)element);
                break;
            }
            case OBJECT_MODEL_CLASS: {
                this.transformFromClass((ObjectModelClass)element);
                break;
            }
            case OBJECT_MODEL_ENUMERATION: {
                this.transformFromEnumeration((ObjectModelEnumeration)element);
            }
        }
    }

    public void transformFromModel(ObjectModel model) {
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
    }

    public void transformFromClass(ObjectModelClass clazz) {
    }

    public void transformFromClassifier(ObjectModelClassifier clazz) {
    }

    public void transformFromEnumeration(ObjectModelEnumeration enumeration) {
    }
}

