/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class ParameterDef
extends ElementDef {
    private final String type;
    private String fullyQualifiedType;

    public static ParameterDef of(ObjectModelParameter aParameter, String defaultPackage) {
        ParameterDef result = new ParameterDef(aParameter.getName(), ParameterDef.getRelativeType(aParameter.getType(), defaultPackage));
        result.loadStereotypesAndTagValues(aParameter);
        return result;
    }

    public static ParameterDef of(String lineDef) {
        Pair<String, String> pair = ParameterDef.splitTagValues(lineDef);
        lineDef = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        int index = lineDef.indexOf(32);
        String name = lineDef.substring(0, index - 1).trim();
        String type = lineDef.substring(index + 1).trim();
        ParameterDef result = new ParameterDef(name, type);
        if (tagValues != null) {
            result.loadStereotypesAndTagValues(tagValues);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getName() + ": " + this.type;
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.append(this.getName()).append(" ");
        writer.append(this.type);
        this.writeStereotypesAndTagValues(writer);
    }

    void resolveType(Map<String, String> classesMapping) {
        this.fullyQualifiedType = this.resolveType(this.type, classesMapping);
    }

    ObjectModelParameterImpl toObjectModel() {
        ObjectModelParameterImpl result = new ObjectModelParameterImpl();
        result.setName(this.getName());
        result.setType(this.getFullyQualifiedType());
        this.flushStereotypesAndTagValues(result);
        return result;
    }

    private String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    private ParameterDef(String name, String type) {
        super(name);
        this.type = type;
    }
}

