/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelPackageImpl;

public class PackageDef
extends ElementDef
implements Comparable<PackageDef> {
    static final String PREFIX = "package ";
    private final String fullyQualifiedName;

    public static PackageDef of(ObjectModelPackage aPackage) {
        PackageDef result = new PackageDef(aPackage.getName());
        result.loadStereotypesAndTagValues(aPackage);
        return result;
    }

    public static PackageDef of(String lineDef) {
        String firstLine = StringUtils.removeStart((String)lineDef, (String)PREFIX).trim();
        Pair<String, String> pair = PackageDef.splitTagValues(firstLine);
        firstLine = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        PackageDef result = new PackageDef(firstLine);
        if (tagValues != null) {
            result.loadStereotypesAndTagValues(tagValues);
        }
        return result;
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        if (this.getStereotypes().isEmpty() && this.getTagValues().isEmpty()) {
            return;
        }
        writer.newLine();
        writer.append(PREFIX).append(this.getName());
        this.writeStereotypesAndTagValues(writer);
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public int compareTo(PackageDef o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    ObjectModelPackageImpl toObjectModel() {
        ObjectModelPackageImpl result = new ObjectModelPackageImpl();
        result.setName(this.getFullyQualifiedName());
        this.flushStereotypesAndTagValues(result);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageDef that = (PackageDef)o;
        return Objects.equals(this.fullyQualifiedName, that.fullyQualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.fullyQualifiedName);
    }

    private PackageDef(String name) {
        super(name);
        this.fullyQualifiedName = name;
    }
}

