/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.ClassDef;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.friend.EnumDef;
import org.nuiton.eugene.models.friend.InterfaceDef;
import org.nuiton.eugene.models.friend.PackageDef;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelDependencyImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelPackageImpl;

public class ModelDef
extends ElementDef {
    private static final Logger log = LogManager.getLogger(ModelDef.class);
    private static final String DEFAULT_PACKAGE = "defaultPackage";
    private static final String PREFIX = "model ";
    private static final String VERSION = "version";
    private static final String CONSTANTS = "constants";
    private static final String SKIP = "skip";
    private final List<PackageDef> packages = new LinkedList<PackageDef>();
    private final List<InterfaceDef> interfaces = new LinkedList<InterfaceDef>();
    private final List<ClassDef> classes = new LinkedList<ClassDef>();
    private final List<EnumDef> enumerations = new LinkedList<EnumDef>();

    private ModelDef(String name) {
        super(name);
    }

    public static ModelDef of(ObjectModel objectModel) {
        Object defaultPackage;
        ModelDef model = new ModelDef(objectModel.getName());
        model.loadStereotypesAndTagValues(objectModel);
        if (objectModel.getVersion() != null) {
            model.addTagValue(VERSION, objectModel.getVersion());
        }
        defaultPackage = (defaultPackage = objectModel.getTagValue(DEFAULT_PACKAGE)) == null ? "" : (String)defaultPackage + ".";
        for (ObjectModelPackage aPackage : objectModel.getPackages()) {
            model.add(PackageDef.of(aPackage));
        }
        for (ObjectModelEnumeration anEnumeration : objectModel.getEnumerations()) {
            model.add(PackageDef.of(anEnumeration.getPackageName()));
            model.add(EnumDef.of(anEnumeration, (String)defaultPackage));
        }
        for (ObjectModelInterface anInterface : objectModel.getInterfaces()) {
            model.add(PackageDef.of(anInterface.getPackageName()));
            model.add(InterfaceDef.of(anInterface, (String)defaultPackage));
        }
        for (ObjectModelClass aClass : objectModel.getClasses()) {
            model.add(PackageDef.of(aClass.getPackageName()));
            model.add(ClassDef.of(aClass, (String)defaultPackage));
        }
        model.computeFullyQualifiedName(new LinkedHashMap<String, String>());
        return model;
    }

    public static ModelDef of(ObjectModel objectModel, BufferedReader reader) throws IOException {
        String line;
        ModelDef model = null;
        LinkedList<String> packages = new LinkedList<String>();
        Map<String, String> classesMapping = new LinkedHashMap<String, String>();
        if (objectModel != null && objectModel.getName() != null) {
            ModelDef incomingModel = ModelDef.of(objectModel);
            model = ModelDef.of(PREFIX + incomingModel.getName());
            packages.addAll(incomingModel.getPackages().stream().map(PackageDef::getFullyQualifiedName).collect(Collectors.toSet()));
            incomingModel.getStereotypes().forEach(model::addStereotype);
            incomingModel.getTagValues().forEach(model::addTagValue);
            classesMapping = incomingModel.generateClassesMapping(classesMapping);
        }
        LinkedList linesGrouped = new LinkedList();
        LinkedList<String> currentGroup = null;
        int linesCount = 0;
        while ((line = reader.readLine()) != null) {
            ++linesCount;
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.isEmpty()) {
                if (currentGroup == null || currentGroup.isEmpty()) continue;
                linesGrouped.add(currentGroup);
                currentGroup = null;
                continue;
            }
            if (currentGroup == null) {
                currentGroup = new LinkedList<String>();
            }
            if (line.startsWith(PREFIX)) {
                if (model == null) {
                    model = ModelDef.of(line);
                    continue;
                }
                int tagValuesIndexOf = line.indexOf(124);
                if (tagValuesIndexOf == -1) continue;
                model.loadStereotypesAndTagValues(line.substring(tagValuesIndexOf + 1).trim());
                continue;
            }
            if (line.startsWith("package ")) {
                packages.add(line);
                continue;
            }
            currentGroup.add(line);
        }
        if (currentGroup != null && !currentGroup.isEmpty()) {
            linesGrouped.add(currentGroup);
        }
        log.debug(String.format("Loading %d line(s)", linesCount));
        log.debug(String.format("Loading %d group(s)", linesGrouped.size()));
        Objects.requireNonNull(model);
        Object defaultPackage = model.getTagValues().get(DEFAULT_PACKAGE);
        defaultPackage = defaultPackage == null ? "" : (String)defaultPackage + ".";
        for (String string : packages) {
            model.add(PackageDef.of(string));
        }
        for (List list : linesGrouped) {
            model.loadGroup(list, (String)defaultPackage);
        }
        model.computeFullyQualifiedName(classesMapping);
        return model;
    }

    public static ModelDef of(String line) {
        String firstLine = StringUtils.removeStart((String)line, (String)PREFIX).trim();
        int tagValuesIndexOf = firstLine.indexOf(124);
        if (tagValuesIndexOf != -1) {
            String tagValues = firstLine.substring(tagValuesIndexOf + 1).trim();
            firstLine = firstLine.substring(0, tagValuesIndexOf - 1);
            ModelDef modelDef = new ModelDef(firstLine.trim());
            modelDef.loadStereotypesAndTagValues(tagValues);
            return modelDef;
        }
        return new ModelDef(firstLine.trim());
    }

    private void computeFullyQualifiedName(Map<String, String> incomingClassesMapping) {
        Map<String, String> classesMapping = this.generateClassesMapping(incomingClassesMapping);
        for (InterfaceDef anInterface : this.interfaces) {
            anInterface.resolveTypes(classesMapping);
        }
        for (EnumDef anEnum : this.enumerations) {
            anEnum.resolveTypes(classesMapping);
        }
        for (ClassDef aClass : this.classes) {
            aClass.resolveTypes(classesMapping);
        }
    }

    private Map<String, String> generateClassesMapping(Map<String, String> incomingClassesMapping) {
        TreeMap<String, String> classesMapping = new TreeMap<String, String>(incomingClassesMapping);
        for (InterfaceDef anInterface : this.interfaces) {
            classesMapping.put(anInterface.getName(), anInterface.getFullyQualifiedName());
        }
        for (EnumDef anEnum : this.enumerations) {
            classesMapping.put(anEnum.getName(), anEnum.getFullyQualifiedName());
        }
        for (ClassDef aClass : this.classes) {
            classesMapping.put(aClass.getName(), aClass.getFullyQualifiedName());
        }
        return classesMapping;
    }

    private void loadGroup(List<String> groupLines, String defaultPackage) {
        String firstLine = groupLines.remove(0);
        if (firstLine.startsWith("interface ")) {
            this.add(InterfaceDef.of(firstLine, groupLines, defaultPackage));
            return;
        }
        if (firstLine.startsWith("enum ")) {
            this.add(EnumDef.of(firstLine, groupLines, defaultPackage));
            return;
        }
        this.add(ClassDef.of(firstLine, groupLines, defaultPackage));
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        Collections.sort(this.packages);
        Collections.sort(this.enumerations);
        Collections.sort(this.interfaces);
        Collections.sort(this.classes);
        writer.append(PREFIX).append(this.getName());
        this.writeStereotypesAndTagValues(writer);
        writer.newLine();
        for (PackageDef aPackage : this.packages) {
            aPackage.write(writer);
        }
        writer.newLine();
        for (EnumDef enumeration : this.enumerations) {
            enumeration.write(writer);
        }
        for (InterfaceDef anInterface : this.interfaces) {
            anInterface.write(writer);
        }
        for (ClassDef aClass : this.classes) {
            aClass.write(writer);
        }
    }

    private void add(PackageDef packageDef) {
        for (PackageDef aPackage : this.packages) {
            if (!packageDef.equals(aPackage)) continue;
            return;
        }
        log.debug(String.format("Add package: %s", packageDef));
        this.packages.add(packageDef);
    }

    private void add(EnumDef enumDef) {
        log.debug(String.format("Add enum: %s", enumDef));
        this.enumerations.add(enumDef);
    }

    private void add(InterfaceDef interfaceDef) {
        log.debug(String.format("Add interface: %s", interfaceDef));
        this.interfaces.add(interfaceDef);
    }

    public void add(ClassDef classDef) {
        log.debug(String.format("Add class: %s", classDef));
        this.classes.add(classDef);
    }

    public List<PackageDef> getPackages() {
        return this.packages;
    }

    public List<InterfaceDef> getInterfaces() {
        return this.interfaces;
    }

    public List<ClassDef> getClasses() {
        return this.classes;
    }

    public List<EnumDef> getEnumerations() {
        return this.enumerations;
    }

    public void load(String line) {
        String firstLine = StringUtils.removeStart((String)line, (String)PREFIX).trim();
        int tagValuesIndexOf = firstLine.indexOf(124);
        if (tagValuesIndexOf != -1) {
            String tagValues = firstLine.substring(tagValuesIndexOf + 1).trim();
            this.loadStereotypesAndTagValues(tagValues);
        }
    }

    public void toObjectModel(ObjectModelImpl result) {
        ObjectModelDependencyImpl dependency;
        ObjectModelClassifierImpl parent;
        ObjectModelPackageImpl aPackage;
        ObjectModelEnumeration enumeration;
        result.setName(this.getName());
        if (this.getTagValues().containsKey(VERSION)) {
            result.setVersion(this.getTagValues().get(VERSION));
        }
        this.flushStereotypesAndTagValues(result);
        for (PackageDef aPackage2 : this.packages) {
            result.addPackage(aPackage2.toObjectModel());
        }
        for (EnumDef anEnumeration : this.enumerations) {
            enumeration = anEnumeration.toObjectModel();
            result.addEnumeration((ObjectModelEnumerationImpl)enumeration);
            aPackage = new ObjectModelPackageImpl();
            aPackage.setName(((ObjectModelClassifierImpl)((Object)enumeration)).getPackageName());
            result.addPackage(aPackage);
        }
        for (InterfaceDef anInterface : this.interfaces) {
            ObjectModelInterfaceImpl interfacez = anInterface.toObjectModel();
            result.addInterface(interfacez);
            aPackage = new ObjectModelPackageImpl();
            aPackage.setName(interfacez.getPackageName());
            result.addPackage(aPackage);
        }
        for (ClassDef aClass : this.classes) {
            ObjectModelClassImpl clazz = aClass.toObjectModel();
            aPackage = new ObjectModelPackageImpl();
            aPackage.setName(clazz.getPackageName());
            result.addPackage(aPackage);
            result.addClass(clazz);
        }
        for (ClassDef aClass : this.classes) {
            aClass.addReverseAttributes(result);
            enumeration = result.getEnumeration(aClass.getFullyQualifiedName() + "Constants");
            if (enumeration == null) continue;
            parent = (ObjectModelClassImpl)result.getClass(aClass.getFullyQualifiedName());
            dependency = new ObjectModelDependencyImpl();
            dependency.setName(CONSTANTS);
            dependency.setClient(parent);
            dependency.setSupplierName(enumeration.getQualifiedName());
            parent.addDependency(dependency);
            enumeration.addStereotype(SKIP);
        }
        for (InterfaceDef anInterface : this.interfaces) {
            enumeration = result.getEnumeration(anInterface.getFullyQualifiedName() + "Constants");
            if (enumeration == null) continue;
            parent = (ObjectModelInterfaceImpl)result.getInterface(anInterface.getFullyQualifiedName());
            dependency = new ObjectModelDependencyImpl();
            dependency.setName(CONSTANTS);
            dependency.setClient(parent);
            dependency.setSupplierName(enumeration.getQualifiedName());
            parent.addDependency(dependency);
            enumeration.addStereotype(SKIP);
        }
    }
}

