/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.ClassifierDef;
import org.nuiton.eugene.models.friend.OperationDef;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;

public class InterfaceDef
extends ClassifierDef<InterfaceDef> {
    public static final String PREFIX = "interface ";
    private static final Logger log = LogManager.getLogger(InterfaceDef.class);
    private final List<String> extend = new LinkedList<String>();
    private final List<String> fullyQualifiedExtend = new LinkedList<String>();

    public static InterfaceDef of(ObjectModelInterface anInterface, String defaultPackage) {
        InterfaceDef result = new InterfaceDef(InterfaceDef.getRelativeType(anInterface.getQualifiedName(), defaultPackage), defaultPackage);
        result.loadStereotypesAndTagValues(anInterface);
        for (ObjectModelInterface objectModelInterface : anInterface.getInterfaces()) {
            result.addExtend(objectModelInterface.getQualifiedName());
        }
        for (ObjectModelOperation objectModelOperation : anInterface.getOperations()) {
            result.add(OperationDef.of(objectModelOperation, defaultPackage));
        }
        return result;
    }

    public static InterfaceDef of(String line, List<String> groupLines, String defaultPackage) {
        String firstLine = StringUtils.removeStart((String)line, (String)PREFIX).trim();
        Pair<String, String> pair = InterfaceDef.splitTagValues(firstLine);
        firstLine = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        int extendIndexOf = firstLine.indexOf(62);
        String extend = null;
        if (extendIndexOf != -1) {
            extend = firstLine.substring(extendIndexOf + 1).trim();
            firstLine = firstLine.substring(0, extendIndexOf - 1);
        }
        InterfaceDef result = new InterfaceDef(firstLine.trim(), defaultPackage);
        if (tagValues != null) {
            result.loadStereotypesAndTagValues(tagValues);
        }
        if (extend != null) {
            for (String oneExtend : extend.split(",")) {
                String trim = oneExtend.trim();
                if (trim.isEmpty()) continue;
                result.addExtend(trim);
            }
        }
        for (String groupLine : groupLines) {
            result.add(OperationDef.of(groupLine));
        }
        return result;
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.newLine();
        writer.append(PREFIX).append(this.getName());
        this.writeSimpleList(this.getExtend(), " > ", writer);
        this.writeStereotypesAndTagValues(writer);
        for (OperationDef operationDef : this.getOperations()) {
            operationDef.write(writer);
        }
        writer.newLine();
    }

    public String toString() {
        return this.getName() + (String)(this.getExtend().isEmpty() ? "" : " extends " + Joiner.on((String)",").join(this.extend)) + (String)(this.getOperations().isEmpty() ? "" : " ops: " + Joiner.on((String)",").join(this.getOperations()));
    }

    List<String> getExtend() {
        return this.extend;
    }

    List<String> getFullyQualifiedExtend() {
        return this.fullyQualifiedExtend;
    }

    @Override
    void resolveTypes(Map<String, String> classesMapping) {
        super.resolveTypes(classesMapping);
        this.fullyQualifiedExtend.clear();
        for (String extend : this.extend) {
            this.fullyQualifiedExtend.add(this.resolveType(extend, classesMapping));
        }
    }

    ObjectModelInterfaceImpl toObjectModel() {
        ObjectModelInterfaceImpl result = new ObjectModelInterfaceImpl();
        this.toObjectModel(result);
        for (String fullyQualifiedExtend : this.fullyQualifiedExtend) {
            ObjectModelImplRef ref = new ObjectModelImplRef();
            ref.setName(fullyQualifiedExtend);
            result.addInterface(ref);
        }
        return result;
    }

    private void addExtend(String extend) {
        log.debug(String.format("Add extend: %s on %s", extend, this.getName()));
        this.extend.add(extend);
    }

    private InterfaceDef(String name, String defaultPackage) {
        super(name, defaultPackage);
    }
}

