/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.friend.OperationDef;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;

public abstract class ClassifierDef<D extends ClassifierDef<?>>
extends ElementDef
implements Comparable<D> {
    private static final Logger log = LogManager.getLogger(ClassifierDef.class);
    private final String fullyQualifiedName;
    private final List<OperationDef> operations = new LinkedList<OperationDef>();

    ClassifierDef(String name, String defaultPackage) {
        super(name);
        this.fullyQualifiedName = name.startsWith("!") ? name.substring(1) : defaultPackage + name;
    }

    String getSimpleName() {
        if (this.getName().contains(".")) {
            return this.getName().substring(this.getName().lastIndexOf(".") + 1);
        }
        return this.getName();
    }

    public List<OperationDef> getOperations() {
        return this.operations;
    }

    @Override
    public int compareTo(D o) {
        return this.getFullyQualifiedName().compareTo(((ClassifierDef)o).getFullyQualifiedName());
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    void add(OperationDef operationDef) {
        log.debug(String.format("Add operation: %s on %s", operationDef, this.getName()));
        this.operations.add(operationDef);
    }

    void resolveTypes(Map<String, String> classesMapping) {
        for (OperationDef operation : this.operations) {
            operation.resolveTypes(classesMapping);
        }
    }

    void toObjectModel(ObjectModelClassifierImpl classifier) {
        String fullyQualifiedName = this.getFullyQualifiedName();
        int lastIndexOf = fullyQualifiedName.lastIndexOf(46);
        classifier.setName(fullyQualifiedName.substring(lastIndexOf + 1));
        classifier.setPackage(fullyQualifiedName.substring(0, lastIndexOf));
        this.flushStereotypesAndTagValues(classifier);
        for (OperationDef operationDef : this.getOperations()) {
            classifier.addOperation(operationDef.toObjectModel());
        }
    }
}

