/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import com.google.common.base.Joiner;
import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.AttributeDef;
import org.nuiton.eugene.models.friend.ClassifierDef;
import org.nuiton.eugene.models.friend.OperationDef;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplSuperClassRef;

public class ClassDef
extends ClassifierDef<ClassDef> {
    private static final String PREFIX = "class ";
    private final boolean isAbstract;
    private static final Logger log = LogManager.getLogger(ClassDef.class);
    private String extend;
    private String fullyQualifiedExtend;
    private final List<String> implement = new LinkedList<String>();
    private final List<String> fullyQualifiedImplement = new LinkedList<String>();
    private final List<AttributeDef> attributes = new LinkedList<AttributeDef>();

    public static ClassDef of(ObjectModelClass aClass, String defaultPackage) {
        ClassDef result = new ClassDef(ClassDef.getRelativeType(aClass.getQualifiedName(), defaultPackage), defaultPackage, aClass.isAbstract());
        Collection<ObjectModelClass> superclasses = aClass.getSuperclasses();
        if (!superclasses.isEmpty()) {
            result.setExtend(ClassDef.getRelativeType(superclasses.iterator().next().getQualifiedName(), defaultPackage));
        }
        result.loadStereotypesAndTagValues(aClass);
        for (ObjectModelInterface objectModelInterface : aClass.getInterfaces()) {
            result.addImplement(ClassDef.getRelativeType(objectModelInterface.getQualifiedName(), defaultPackage));
        }
        for (ObjectModelOperation objectModelOperation : aClass.getOperations()) {
            result.add(OperationDef.of(objectModelOperation, defaultPackage));
        }
        String reverseDefaultName = Introspector.decapitalize(aClass.getName());
        for (ObjectModelAttribute anAttribute : aClass.getAttributes()) {
            if (!anAttribute.isNavigable()) continue;
            result.add(AttributeDef.of(anAttribute, defaultPackage, reverseDefaultName));
        }
        return result;
    }

    public static ClassDef of(String firstLine, List<String> groupLines, String defaultPackage) {
        firstLine = StringUtils.removeStart((String)firstLine, (String)PREFIX);
        Pair<String, String> pair = ClassDef.splitTagValues(firstLine);
        firstLine = (String)pair.getLeft();
        boolean isAbstract = false;
        if (firstLine.startsWith("abstract ")) {
            firstLine = firstLine.substring("abstract ".length()).trim();
            isAbstract = true;
        }
        String tagValues = (String)pair.getRight();
        int implementIndexOf = firstLine.indexOf(">>");
        String implement = null;
        if (implementIndexOf != -1) {
            implement = firstLine.substring(implementIndexOf + 2).trim();
            firstLine = firstLine.substring(0, implementIndexOf - 1);
        }
        int extendIndexOf = firstLine.indexOf(62);
        String extend = null;
        if (extendIndexOf != -1) {
            extend = firstLine.substring(extendIndexOf + 1).trim();
            firstLine = firstLine.substring(0, extendIndexOf - 1);
        }
        ClassDef def = new ClassDef(firstLine.trim(), defaultPackage, isAbstract);
        if (tagValues != null) {
            def.loadStereotypesAndTagValues(tagValues);
        }
        if (implement != null) {
            for (String oneImplement : implement.split(" ")) {
                def.addImplement(oneImplement.trim());
            }
        }
        if (extend != null) {
            def.setExtend(extend.trim());
        }
        for (String groupLine : groupLines) {
            if (groupLine.contains("(")) {
                def.add(OperationDef.of(groupLine));
                continue;
            }
            def.add(AttributeDef.of(groupLine));
        }
        return def;
    }

    private ClassDef(String name, String defaultPackage, boolean isAbstract) {
        super(name, defaultPackage);
        this.isAbstract = isAbstract;
    }

    public String getFullyQualifiedExtend() {
        return this.fullyQualifiedExtend;
    }

    public List<String> getFullyQualifiedImplement() {
        return this.fullyQualifiedImplement;
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.newLine();
        if (this.isAbstract) {
            writer.append("abstract ");
        }
        writer.append(this.getName());
        if (this.extend != null) {
            writer.append(" > ").append(this.getExtend());
        }
        this.writeSimpleList(this.getImplement(), " >> ", writer);
        this.writeStereotypesAndTagValues(writer);
        for (AttributeDef attributeDef : this.attributes) {
            attributeDef.write(writer);
        }
        for (OperationDef operationDef : this.getOperations()) {
            operationDef.write(writer);
        }
        writer.newLine();
    }

    private void addImplement(String implement) {
        log.debug(String.format("Add implement: %s on %s", implement, this.getName()));
        this.implement.add(implement);
    }

    private void add(AttributeDef attributeDef) {
        log.debug(String.format("Add attribute: %s on %s", attributeDef, this.getName()));
        this.attributes.add(attributeDef);
    }

    @Override
    public int compareTo(ClassDef o) {
        if (this.isAbstract) {
            return o.isAbstract ? this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName()) : -1;
        }
        return o.isAbstract ? 1 : this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    private void setExtend(String extend) {
        this.extend = extend;
    }

    public String toString() {
        return this.getName() + (String)(this.getExtend() == null ? "" : " extends " + this.extend) + (String)(this.getImplement().isEmpty() ? "" : " implements " + Joiner.on((String)",").join(this.implement)) + (String)(this.attributes.isEmpty() ? "" : " attrs: " + Joiner.on((String)",").join(this.attributes)) + (String)(this.getOperations().isEmpty() ? "" : " ops: " + Joiner.on((String)",").join(this.getOperations()));
    }

    private String getExtend() {
        return this.extend;
    }

    private List<String> getImplement() {
        return this.implement;
    }

    public List<AttributeDef> getAttributes() {
        return this.attributes;
    }

    @Override
    void resolveTypes(Map<String, String> classesMapping) {
        super.resolveTypes(classesMapping);
        for (AttributeDef attributeDef : this.attributes) {
            attributeDef.resolveType(classesMapping);
        }
        if (this.extend != null) {
            this.fullyQualifiedExtend = this.resolveType(this.extend, classesMapping);
        }
        this.fullyQualifiedImplement.clear();
        for (String implement : this.implement) {
            this.fullyQualifiedImplement.add(this.resolveType(implement, classesMapping));
        }
    }

    ObjectModelClassImpl toObjectModel() {
        ObjectModelClassImpl result = new ObjectModelClassImpl();
        this.toObjectModel(result);
        if (this.isAbstract) {
            result.setAbstract(true);
        }
        if (this.extend != null) {
            ObjectModelImplSuperClassRef ref = new ObjectModelImplSuperClassRef();
            ref.setName(this.fullyQualifiedExtend);
            result.addSuperclass(ref);
        }
        for (String implement : this.fullyQualifiedImplement) {
            ObjectModelImplRef ref = new ObjectModelImplRef();
            ref.setName(implement);
            result.addInterface(ref);
        }
        return result;
    }

    void addReverseAttributes(ObjectModelImpl model) {
        ObjectModelClassImpl aClass = (ObjectModelClassImpl)model.getClass(this.getFullyQualifiedName());
        for (AttributeDef attribute : this.attributes) {
            ObjectModelAttributeImpl attribute1 = attribute.toObjectModel(this);
            aClass.addAttribute(attribute1);
            String fullyQualifiedType = attribute.getFullyQualifiedType();
            ObjectModelClassImpl classifier = (ObjectModelClassImpl)model.getClass(fullyQualifiedType);
            if (classifier == null) continue;
            String reverseName = attribute.getReverseName(this);
            ObjectModelAttributeImpl reverseAttribute = (ObjectModelAttributeImpl)classifier.getAttribute(reverseName);
            if (reverseAttribute != null && reverseAttribute.getName().equals(attribute.getName())) {
                log.warn("You could us a bidirectional relation for " + aClass.getQualifiedName() + "#" + attribute1.getName());
                continue;
            }
            reverseAttribute = attribute.toReverseModel(this);
            classifier.addAttribute(reverseAttribute);
        }
    }
}

