/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.eugene.models.friend.ClassifierDef;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;

public class AttributeDef
extends ElementDef {
    private final String type;
    private String defaultValue;
    private String fullyQualifiedType;
    private String reverseName;
    private String cardinality;
    private String relationType;

    public AttributeDef(String name, String type, String reverseName, String cardinality, String relationType) {
        super(name);
        this.type = type;
        this.reverseName = reverseName;
        this.cardinality = cardinality;
        this.relationType = relationType;
    }

    public static AttributeDef of(ObjectModelAttribute anAttribute, String defaultPackage, String defaultReverseName) {
        String reverseName;
        int maxMultiplicity;
        int minMultiplicity;
        Object cardinality;
        String relationType = null;
        if (anAttribute.isComposite()) {
            relationType = "+";
        }
        Object object = cardinality = (minMultiplicity = anAttribute.getMinMultiplicity()) == (maxMultiplicity = anAttribute.getMaxMultiplicity()) ? "" + minMultiplicity : minMultiplicity + ".." + maxMultiplicity;
        if (((String)cardinality).equals("0..-1")) {
            cardinality = "*";
        } else if (((String)cardinality).equals("1..-1")) {
            cardinality = "+";
        }
        int reverseMaxMultiplicity = anAttribute.getReverseMaxMultiplicity();
        if (reverseMaxMultiplicity == -1) {
            cardinality = "*:" + (String)cardinality;
        }
        if ("1".equals(cardinality)) {
            cardinality = null;
        }
        if ((reverseName = anAttribute.getReverseAttributeName()) != null && defaultReverseName.equals(reverseName = reverseName.trim())) {
            reverseName = null;
        }
        AttributeDef result = new AttributeDef(anAttribute.getName(), AttributeDef.getRelativeType(anAttribute.getType(), defaultPackage), reverseName, (String)cardinality, relationType);
        result.loadStereotypesAndTagValues(anAttribute);
        return result;
    }

    public static AttributeDef of(String firstLine) {
        String[] nameParts;
        Pair<String, String> pair = AttributeDef.splitTagValues(firstLine);
        firstLine = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        int typeIndexOf = firstLine.lastIndexOf(32);
        String type = firstLine.substring(typeIndexOf + 1).trim();
        firstLine = firstLine.substring(0, typeIndexOf).trim();
        String cardinality = null;
        if (firstLine.contains("{")) {
            int parameterFirstIndex = firstLine.indexOf(123);
            int parameterLastIndex = firstLine.indexOf(125);
            cardinality = firstLine.substring(parameterFirstIndex, parameterLastIndex + 1).replace("{", "").replace("}", "");
            firstLine = firstLine.substring(0, parameterFirstIndex).trim();
        }
        String[] parts = firstLine.split(" ");
        String name = parts[0].trim();
        String relationType = null;
        if (parts.length == 2) {
            relationType = parts[1].trim();
        }
        AttributeDef attributeDef = (nameParts = name.trim().split(":")).length == 1 ? new AttributeDef(name, type, null, cardinality, relationType) : new AttributeDef(nameParts[0].trim(), type, nameParts[1].trim(), cardinality, relationType);
        if (tagValues != null) {
            attributeDef.loadStereotypesAndTagValues(tagValues);
        }
        return attributeDef;
    }

    public String getType() {
        return this.type;
    }

    public String getReverseName() {
        return this.reverseName;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void addTagValue(String key, String value) {
        if ("defaultValue".equals(key)) {
            this.setDefaultValue(value);
        }
        super.addTagValue(key, value);
    }

    public String toString() {
        return this.getName() + (String)(this.reverseName == null ? "" : ":" + this.reverseName) + (String)(this.relationType == null ? "" : " " + this.relationType) + (String)(this.cardinality == null ? "" : " {" + this.cardinality + "}");
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.newLine();
        writer.append(this.getName());
        if (this.reverseName != null) {
            writer.append(":").append(this.reverseName);
        }
        writer.append(" ");
        if (this.relationType != null) {
            writer.append(this.relationType).append(" ");
        }
        if (this.cardinality != null) {
            writer.append("{").append(this.cardinality).append("} ");
        }
        writer.append(this.type);
        this.writeStereotypesAndTagValues(writer);
    }

    boolean isBidirectional() {
        return Objects.equals("-", this.relationType);
    }

    void resolveType(Map<String, String> classesMapping) {
        this.fullyQualifiedType = this.resolveType(this.type, classesMapping);
    }

    ObjectModelAttributeImpl toObjectModel(ClassifierDef container) {
        ObjectModelAttributeImpl result = new ObjectModelAttributeImpl();
        result.setName(this.getName());
        result.setType(this.getFullyQualifiedType());
        result.setReverseAttributeName(this.reverseName == null ? Introspector.decapitalize(container.getSimpleName()) : this.reverseName);
        this.flushStereotypesAndTagValues(result);
        result.setUnique(result.getStereotypes().contains("unique"));
        result.setDefaultValue(this.getDefaultValue());
        if (this.relationType != null && this.relationType.contains("+")) {
            result.setAssociationType("composite");
        }
        if (this.cardinality == null) {
            result.setMinMultiplicity(1);
            result.setMaxMultiplicity(1);
            result.setReverseMaxMultiplicity(1);
        } else {
            Integer reverseMax;
            Integer max;
            Integer min;
            String toCard;
            String fromCard;
            String[] split = this.cardinality.split(":");
            if (split.length == 1) {
                fromCard = "1";
                toCard = split[0];
            } else {
                fromCard = split[0];
                toCard = split[1];
            }
            switch (toCard) {
                case "*": {
                    min = 0;
                    max = -1;
                    break;
                }
                case "+": {
                    min = 1;
                    max = -1;
                    break;
                }
                case "0..1": {
                    min = 0;
                    max = 1;
                    break;
                }
                default: {
                    min = 1;
                    max = 1;
                }
            }
            switch (fromCard) {
                case "*": 
                case "+": {
                    reverseMax = -1;
                    break;
                }
                case "0..1": {
                    reverseMax = 1;
                    break;
                }
                default: {
                    reverseMax = 1;
                }
            }
            result.setMinMultiplicity(min);
            result.setMaxMultiplicity(max);
            result.setReverseMaxMultiplicity(reverseMax);
        }
        result.setNavigable(true);
        return result;
    }

    public String getReverseName(ClassifierDef container) {
        return this.reverseName == null ? Introspector.decapitalize(container.getSimpleName()) : this.reverseName;
    }

    ObjectModelAttributeImpl toReverseModel(ClassifierDef container) {
        ObjectModelAttributeImpl result = new ObjectModelAttributeImpl();
        result.setName(this.getReverseName());
        result.setReverseAttributeName(this.getName());
        result.setType(container.getFullyQualifiedName());
        result.setUnique(false);
        if (this.cardinality == null) {
            result.setMinMultiplicity(1);
            result.setMaxMultiplicity(1);
            result.setReverseMaxMultiplicity(1);
        } else {
            Integer reverseMax;
            Integer max;
            String toCard;
            String fromCard;
            String[] split = this.cardinality.split(":");
            if (split.length == 1) {
                fromCard = "1";
                toCard = split[0];
            } else {
                fromCard = split[0];
                toCard = split[1];
            }
            switch (toCard) {
                case "*": {
                    max = -1;
                    break;
                }
                case "+": {
                    max = -1;
                    break;
                }
                case "0..1": {
                    max = 1;
                    break;
                }
                default: {
                    max = 1;
                }
            }
            switch (fromCard) {
                case "*": 
                case "+": {
                    reverseMax = -1;
                    break;
                }
                case "0..1": {
                    reverseMax = 1;
                    break;
                }
                default: {
                    reverseMax = 1;
                }
            }
            result.setMinMultiplicity(0);
            result.setMaxMultiplicity(reverseMax);
            result.setReverseMaxMultiplicity(max);
        }
        result.setNavigable(this.relationType != null && this.relationType.contains("-"));
        return result;
    }
}

