/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.tagvalue.provider;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.eugene.models.extension.tagvalue.MismatchTagValueTargetException;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueNotFoundException;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.matcher.StartsWithTagNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.matcher.TagValueDefinitionMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;

public abstract class DefaultTagValueMetadatasProvider
implements TagValueMetadatasProvider {
    protected final Set<TagValueMetadata> tagValues;
    protected final Set<TagValueDefinitionMatcher> matcher;

    public DefaultTagValueMetadatasProvider(TagValueMetadata ... tagValues) {
        this.tagValues = ImmutableSet.copyOf((Object[])tagValues);
        this.matcher = ImmutableSet.of((Object)new EqualsTagValueNameMatcher(this.getDefinitionForMatcher(EqualsTagValueNameMatcher.class)), (Object)new StartsWithTagNameMatcher(this.getDefinitionForMatcher(StartsWithTagNameMatcher.class)));
    }

    @Override
    public Set<TagValueMetadata> getTagValues() {
        return this.tagValues;
    }

    @Override
    public void validate(String tagValueName, Class<?> type) throws TagValueNotFoundException, MismatchTagValueTargetException {
        Optional<TagValueMetadata> def = this.getTagValue(tagValueName);
        if (!def.isPresent()) {
            throw new TagValueNotFoundException();
        }
        boolean valid = false;
        for (Class<?> target : ((TagValueMetadata)def.get()).getTargets()) {
            if (!target.equals(type) && !target.isAssignableFrom(type)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new MismatchTagValueTargetException();
        }
    }

    @Override
    public Optional<TagValueMetadata> getTagValue(String tagValueName) {
        for (TagValueDefinitionMatcher tagValueDefinitionMatcher : this.matcher) {
            TagValueMetadata def = tagValueDefinitionMatcher.match(tagValueName);
            if (def == null) continue;
            return Optional.of((Object)def);
        }
        return Optional.absent();
    }

    protected <M extends TagValueDefinitionMatcher> Set<TagValueMetadata> getDefinitionForMatcher(Class<M> matcherType) {
        LinkedHashSet<TagValueMetadata> result = new LinkedHashSet<TagValueMetadata>();
        for (TagValueMetadata entry : this.getTagValues()) {
            if (!matcherType.equals(entry.getMatcherClass())) continue;
            result.add(entry);
        }
        return result;
    }
}

