/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.tagvalue;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class TagValueUtil {
    protected static final Pattern TAG_VALUE_PATTERN = Pattern.compile("^((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)(?:(class|attribute|operation))\\.(?:([_a-zA-Z0-9]+)\\.)?(?:(tagvalue|tagValue)?)\\.((?:[_a-zA-Z0-9]+)+(?:\\.?[_a-zA-Z0-9]+)*)?$");
    protected static final Pattern MODEL_TAG_VALUE_PATTERN = Pattern.compile("^model\\.(?:(tagvalue|tagValue)?)\\.((?:[_a-zA-Z0-9]+)+(?:\\.?[_a-zA-Z0-9]+)*)$");
    protected static final Pattern PACKAGE_TAG_VALUE_PATTERN = Pattern.compile("^package\\.((?:[_a-zA-Z0-9]+\\.)+)(?:(tagvalue|tagValue)?)\\.((?:[_a-zA-Z0-9]+)+(?:\\.?[_a-zA-Z0-9]+)*)$");
    protected static final Pattern PACKAGE_STEREOTYPE_PATTERN = Pattern.compile("^package\\.((?:[_a-zA-Z0-9]+\\.)+)?(?:(stereotype)?)$");
    protected static final Pattern STEREOTYPE_PATTERN = Pattern.compile("^((?:[_a-zA-Z0-9]+\\.)+(?:_?[a-zA-Z][_a-zA-Z0-9]*\\.)+)(?:(class|attribute|operation))\\.(?:([_a-zA-Z0-9]+)\\.)?(?:(stereotype)?)$");

    public static Matcher getModelMatcher(String key) throws InvalidTagValueSyntaxException {
        Matcher matcher = MODEL_TAG_VALUE_PATTERN.matcher(key);
        if (!matcher.find()) {
            throw new InvalidTagValueSyntaxException();
        }
        return matcher;
    }

    public static Matcher getPackageMatcher(String key) throws InvalidTagValueSyntaxException {
        Matcher matcher = PACKAGE_TAG_VALUE_PATTERN.matcher(key);
        if (!matcher.find()) {
            throw new InvalidTagValueSyntaxException();
        }
        return matcher;
    }

    public static Matcher getMatcher(String key) throws InvalidTagValueSyntaxException {
        Matcher matcher = TAG_VALUE_PATTERN.matcher(key);
        if (!matcher.find()) {
            throw new InvalidTagValueSyntaxException();
        }
        return matcher;
    }

    public static String findTagValue(TagValueMetadata tagName, WithTagValuesOrStereotypes ... elements) {
        String result = TagValueUtil.findDirectTagValue(tagName, elements);
        if (result != null) {
            return result;
        }
        for (WithTagValuesOrStereotypes element : elements) {
            String value;
            ObjectModelElement declaringElement;
            if (!(element instanceof ObjectModelElement) || (declaringElement = ((ObjectModelElement)element).getDeclaringElement()) == null || (value = TagValueUtil.findNotEmptyTagValue(tagName, (WithTagValuesOrStereotypes)declaringElement)) == null) continue;
            return value;
        }
        return tagName.getDefaultValue();
    }

    public static String findTagValue(String tagName, String defaultValue, WithTagValuesOrStereotypes ... elements) {
        String result = TagValueUtil.findDirectTagValue(tagName, elements);
        if (result != null) {
            return result;
        }
        for (WithTagValuesOrStereotypes element : elements) {
            String value;
            ObjectModelElement declaringElement;
            if (!(element instanceof ObjectModelElement) || (declaringElement = ((ObjectModelElement)element).getDeclaringElement()) == null || (value = TagValueUtil.findNotEmptyTagValue(tagName, (WithTagValuesOrStereotypes)declaringElement)) == null) continue;
            return value;
        }
        return defaultValue;
    }

    public static boolean findBooleanTagValue(TagValueMetadata tagName, WithTagValuesOrStereotypes ... elements) {
        String value = TagValueUtil.findTagValue(tagName, elements);
        return TagValueUtil.findBooleanTagValue(value);
    }

    public static boolean findBooleanTagValue(String value) {
        return "true".equalsIgnoreCase(value);
    }

    public static Integer findIntegerTagValue(String value) {
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static Boolean findNullableBooleanTagValue(TagValueMetadata tagName, WithTagValuesOrStereotypes ... elements) {
        String value = TagValueUtil.findTagValue(tagName, elements);
        return value == null ? null : Boolean.valueOf("true".equalsIgnoreCase(value));
    }

    public static String findDirectTagValue(TagValueMetadata tagName, WithTagValuesOrStereotypes ... elements) {
        for (WithTagValuesOrStereotypes element : elements) {
            String value = TagValueUtil.findNotEmptyTagValue(tagName, element);
            if (value != null) {
                return value;
            }
            if (!(element instanceof ObjectModelPackage)) continue;
            ObjectModelPackage aPackage = (ObjectModelPackage)element;
            value = null;
            while (value == null && aPackage.getParentPackage() != null) {
                aPackage = aPackage.getParentPackage();
                value = TagValueUtil.findNotEmptyTagValue(tagName, aPackage);
            }
        }
        return tagName.getDefaultValue();
    }

    public static String findDirectTagValue(String tagName, WithTagValuesOrStereotypes ... elements) {
        for (WithTagValuesOrStereotypes element : elements) {
            String value = TagValueUtil.findNotEmptyTagValue(tagName, element);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String findNotEmptyTagValue(TagValueMetadata tagName, WithTagValuesOrStereotypes element) {
        String value = null;
        if (element != null) {
            if (element instanceof ObjectModelPackage) {
                value = TagValueUtil.findNotEmptyTagValue(tagName, (ObjectModelPackage)element);
            } else {
                value = element.getTagValue(tagName.getName());
                if (StringUtils.isEmpty((CharSequence)value)) {
                    value = null;
                }
            }
        }
        return value;
    }

    public static String findNotEmptyTagValue(String tagName, WithTagValuesOrStereotypes element) {
        String value = null;
        if (element != null) {
            if (element instanceof ObjectModelPackage) {
                value = TagValueUtil.findNotEmptyTagValue(tagName, (ObjectModelPackage)element);
            } else {
                value = element.getTagValue(tagName);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    value = null;
                }
            }
        }
        return value;
    }

    protected static String findNotEmptyTagValue(TagValueMetadata tagName, ObjectModelPackage element) {
        String value = element.getTagValue(tagName.getName());
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        if (value == null && element.getParentPackage() != null) {
            value = TagValueUtil.findNotEmptyTagValue(tagName, element.getParentPackage());
        }
        return value;
    }

    protected static String findNotEmptyTagValue(String tagName, ObjectModelPackage element) {
        String value = element.getTagValue(tagName);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        if (value == null && element.getParentPackage() != null) {
            value = TagValueUtil.findNotEmptyTagValue(tagName, element.getParentPackage());
        }
        return value;
    }

    public static Matcher getStereotypeMatcher(String key) throws InvalidStereotypeSyntaxException {
        Matcher matcher = STEREOTYPE_PATTERN.matcher(key);
        if (!matcher.find()) {
            throw new InvalidStereotypeSyntaxException();
        }
        return matcher;
    }

    public static Matcher getPackageStereotypeMatcher(String key) throws InvalidStereotypeSyntaxException {
        Matcher matcher = PACKAGE_STEREOTYPE_PATTERN.matcher(key);
        if (!matcher.find()) {
            throw new InvalidStereotypeSyntaxException();
        }
        return matcher;
    }

    public static Set<String> getStereotypes(String value) {
        Object[] split = value.split("\\s*,\\s*");
        return ImmutableSet.builder().add(split).build();
    }
}

