/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.tagvalue;

import com.google.common.base.Joiner;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class MissingStereoTypeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected final String stereoTypeName;
    protected final String prefixMessage;
    protected final Set<String> stack;

    public MissingStereoTypeException(String stereoTypeName, String prefixMessage, ObjectModelPackage aPackage, ObjectModelClass aClass) {
        this.stereoTypeName = stereoTypeName;
        this.prefixMessage = prefixMessage;
        this.stack = this.getUsageStack(stereoTypeName, aPackage, aClass);
    }

    @Override
    public String toString() {
        return "\n\n" + this.prefixMessage + "\n==========================================================================================\n" + Joiner.on((String)"\n").join(this.stack) + "\n==========================================================================================";
    }

    public LinkedHashSet<String> getUsageStack(String stereoTypeName, ObjectModelPackage aPackage, ObjectModelClass aClass) {
        String suffix = ".stereotype=" + stereoTypeName;
        LinkedHashSet<String> stack = new LinkedHashSet<String>();
        stack.add("model" + suffix);
        this.addPackageStereoTypes(aPackage, suffix, stack);
        stack.add(aClass.getQualifiedName() + ".class" + suffix);
        return stack;
    }

    protected void addPackageStereoTypes(ObjectModelPackage aPackage, String suffix, Set<String> stack) {
        if (aPackage.getParentPackage() != null) {
            this.addPackageStereoTypes(aPackage.getParentPackage(), suffix, stack);
        }
        stack.add("package." + aPackage.getName() + suffix);
    }
}

