/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.model;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.nuiton.eugene.models.extension.model.ModelExtensionAttribute;
import org.nuiton.eugene.models.extension.model.ModelExtensionElement;

public class ModelExtensionClass
extends ModelExtensionElement {
    protected final Set<ModelExtensionAttribute> attributes = new TreeSet<ModelExtensionAttribute>();

    public ModelExtensionClass(String name) {
        super(name);
    }

    public Set<ModelExtensionAttribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getAttributesTagValues() {
        TreeMap<String, String> attributesTagValues = new TreeMap<String, String>();
        for (ModelExtensionAttribute modelExtensionAttribute : this.attributes) {
            for (Map.Entry entry : modelExtensionAttribute.tagValues.entrySet()) {
                if ("true".equals(entry.getValue())) continue;
                attributesTagValues.put(modelExtensionAttribute.name + "." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return attributesTagValues;
    }

    public Set<String> getAttributesStereotypes() {
        TreeSet<String> attributesStereotypes = new TreeSet<String>();
        for (ModelExtensionAttribute modelExtensionAttribute : this.attributes) {
            for (String entry : modelExtensionAttribute.getStereotypes()) {
                attributesStereotypes.add(modelExtensionAttribute.name + "." + entry);
            }
        }
        return attributesStereotypes;
    }

    public ModelExtensionAttribute getOrCreateAttribute(String attributeName) {
        ModelExtensionAttribute result = null;
        for (ModelExtensionAttribute modelExtensionAttribute : this.attributes) {
            if (!attributeName.equals(modelExtensionAttribute.name)) continue;
            result = modelExtensionAttribute;
            break;
        }
        if (result == null) {
            result = new ModelExtensionAttribute(attributeName);
            this.attributes.add(result);
        }
        return result;
    }
}

