/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.model;

import java.io.File;
import java.io.IOException;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParser;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParserCallback;
import org.nuiton.eugene.models.extension.model.ModelExtension;
import org.nuiton.eugene.models.extension.model.ModelExtensionElement;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;

public class ModelExtensionBuilder
implements ModelExtensionFileParserCallback {
    protected final ModelExtension modelExtension;
    protected int modelStereotypeHits;
    protected int modelTagValueHits;
    protected int packageStereotypeHits;
    protected int packageTagValueHits;
    protected int classStereotypeHits;
    protected int classTagValueHits;
    protected int classAttributeStereotypeHits;
    protected int classAttributeTagValueHits;
    protected boolean strictLoading;

    public ModelExtensionBuilder(boolean strictLoading, String modelName) {
        this.modelExtension = new ModelExtension(modelName);
    }

    public ModelExtension build() {
        return this.modelExtension;
    }

    public int getStereotypeHits() {
        return this.modelStereotypeHits + this.packageStereotypeHits + this.classStereotypeHits + this.classAttributeStereotypeHits;
    }

    public int getTagValueHits() {
        return this.modelTagValueHits + this.packageTagValueHits + this.classTagValueHits + this.classAttributeTagValueHits;
    }

    public int getModelStereotypeHits() {
        return this.modelStereotypeHits;
    }

    public int getModelTagValueHits() {
        return this.modelTagValueHits;
    }

    public int getPackageStereotypeHits() {
        return this.packageStereotypeHits;
    }

    public int getPackageTagValueHits() {
        return this.packageTagValueHits;
    }

    public int getClassStereotypeHits() {
        return this.classStereotypeHits;
    }

    public int getClassTagValueHits() {
        return this.classTagValueHits;
    }

    public int getClassAttributeStereotypeHits() {
        return this.classAttributeStereotypeHits;
    }

    public int getClassAttributeTagValueHits() {
        return this.classAttributeTagValueHits;
    }

    @Override
    public boolean onModelTagValueFound(String tag, String value) {
        this.addTagValue(this.modelExtension, tag, value);
        ++this.modelTagValueHits;
        return true;
    }

    @Override
    public boolean onModelStereotypeFound(String stereotype) {
        this.addTagValue(this.modelExtension, stereotype, "true");
        ++this.modelStereotypeHits;
        return true;
    }

    @Override
    public boolean onPackageTagValueFound(String packageName, String tag, String value) {
        this.addTagValue(this.modelExtension.getOrCreatePackage(packageName), tag, value);
        ++this.packageTagValueHits;
        return true;
    }

    @Override
    public boolean onPackageStereotypeFound(String packageName, String stereotype) {
        this.addTagValue(this.modelExtension.getOrCreatePackage(packageName), stereotype, "true");
        ++this.packageStereotypeHits;
        return true;
    }

    @Override
    public boolean onClassTagValueFound(String className, String tag, String value) {
        this.addTagValue(this.modelExtension.getOrCreateClass(className), tag, value);
        ++this.classTagValueHits;
        return true;
    }

    @Override
    public boolean onClassStereotypeFound(String className, String stereotype) {
        this.addTagValue(this.modelExtension.getOrCreateClass(className), stereotype, "true");
        ++this.classStereotypeHits;
        return true;
    }

    @Override
    public boolean onAttributeTagValueFound(String className, String attributeName, String tag, String value) {
        this.addTagValue(this.modelExtension.getOrCreateClassAttribute(className, attributeName), tag, value);
        ++this.classAttributeTagValueHits;
        return true;
    }

    @Override
    public boolean onAttributeStereotypeFound(String className, String attributeName, String stereotype) {
        this.addTagValue(this.modelExtension.getOrCreateClassAttribute(className, attributeName), stereotype, "true");
        ++this.classAttributeStereotypeHits;
        return true;
    }

    public void addFile(File inputFile) throws InvalidTagValueSyntaxException, InvalidStereotypeSyntaxException, IOException {
        ModelExtensionFileParser parser = ModelExtensionFileParser.newParser(this.strictLoading, inputFile);
        parser.parse(inputFile, this);
    }

    protected void addTagValue(ModelExtensionElement modelExtensionElement, String tag, String value) {
        modelExtensionElement.getTagValues().put(tag, value);
    }
}

