/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.model;

import java.util.Set;
import java.util.TreeSet;
import org.nuiton.eugene.models.extension.model.ModelExtensionAttribute;
import org.nuiton.eugene.models.extension.model.ModelExtensionClass;
import org.nuiton.eugene.models.extension.model.ModelExtensionElement;
import org.nuiton.eugene.models.extension.model.ModelExtensionPackage;

public class ModelExtension
extends ModelExtensionElement {
    protected final Set<ModelExtensionPackage> packages = new TreeSet<ModelExtensionPackage>();
    protected final Set<ModelExtensionClass> classes = new TreeSet<ModelExtensionClass>();

    public ModelExtension(String name) {
        super(name);
    }

    public Set<ModelExtensionPackage> getPackages() {
        return this.packages;
    }

    public Set<ModelExtensionClass> getClasses() {
        return this.classes;
    }

    public ModelExtensionPackage getOrCreatePackage(String packageName) {
        ModelExtensionPackage result = null;
        for (ModelExtensionPackage modelExtensionPackage : this.packages) {
            if (!packageName.equals(modelExtensionPackage.name)) continue;
            result = modelExtensionPackage;
            break;
        }
        if (result == null) {
            result = new ModelExtensionPackage(packageName);
            this.packages.add(result);
        }
        return result;
    }

    public ModelExtensionClass getOrCreateClass(String className) {
        ModelExtensionClass result = null;
        for (ModelExtensionClass packageBean : this.classes) {
            if (!className.equals(packageBean.name)) continue;
            result = packageBean;
            break;
        }
        if (result == null) {
            result = new ModelExtensionClass(className);
            this.classes.add(result);
        }
        return result;
    }

    public ModelExtensionAttribute getOrCreateClassAttribute(String className, String attributeName) {
        ModelExtensionClass modelExtensionClass = this.getOrCreateClass(className);
        return modelExtensionClass.getOrCreateAttribute(attributeName);
    }

    public boolean withClasses() {
        return !this.classes.isEmpty();
    }

    public boolean withPackages() {
        return !this.packages.isEmpty();
    }
}

