/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.io;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.eugene.models.extension.io.ModelExtensionWriter;
import org.nuiton.eugene.models.extension.model.ModelExtension;
import org.nuiton.eugene.models.extension.model.ModelExtensionAttribute;
import org.nuiton.eugene.models.extension.model.ModelExtensionClass;
import org.nuiton.eugene.models.extension.model.ModelExtensionPackage;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;

class ModelExtensionWriterPropertiesImpl
extends ModelExtensionWriter {
    private final String eol = System.lineSeparator();

    ModelExtensionWriterPropertiesImpl() {
    }

    @Override
    public void write(ObjectModel modelBean, Writer writer) throws IOException {
        writer.append("# Generated by ").append(this.getClass().getName()).append(" at ").append(new Date().toString()).append(this.eol);
        this.appendMap(modelBean.getTagValues(), "model.tagValue.", writer);
        this.appendSet(modelBean.getStereotypes(), "model.stereotype", writer);
        if (CollectionUtils.isNotEmpty(modelBean.getPackages())) {
            for (ObjectModelPackage packageBean : modelBean.getPackages()) {
                this.appendMap(packageBean.getTagValues(), "package.tagValue.", writer);
                this.appendSet(packageBean.getStereotypes(), "package.stereotype", writer);
            }
        }
        if (CollectionUtils.isNotEmpty(modelBean.getClasses())) {
            for (ObjectModelClass classBean : modelBean.getClasses()) {
                String prefix = classBean.getQualifiedName() + ".class.";
                this.appendMap(classBean.getTagValues(), prefix + "tagValue.", writer);
                this.appendSet(classBean.getStereotypes(), prefix + "stereotype", writer);
                for (ObjectModelAttribute attributeBean : classBean.getAttributes()) {
                    prefix = classBean.getQualifiedName() + ".attribute." + attributeBean.getName() + ".";
                    this.appendMap(attributeBean.getTagValues(), prefix + "tagValue.", writer);
                    this.appendSet(attributeBean.getStereotypes(), prefix + "stereotype", writer);
                }
            }
        }
    }

    @Override
    public void write(ModelExtension model, Writer writer) throws IOException {
        String prefix;
        writer.append("# Generated by ").append(this.getClass().getName()).append(" at ").append(new Date().toString()).append(this.eol);
        this.appendMap(model.getTagValues(), "model.tagValue.", writer);
        this.appendSet(model.getStereotypes(), "model.stereotype", writer);
        if (CollectionUtils.isNotEmpty(model.getPackages())) {
            for (ModelExtensionPackage packageBean : model.getPackages()) {
                prefix = "package." + packageBean.getName() + ".";
                this.appendMap(packageBean.getTagValues(), prefix + "tagValue.", writer);
                this.appendSet(packageBean.getStereotypes(), prefix + "stereotype", writer);
            }
        }
        if (CollectionUtils.isNotEmpty(model.getClasses())) {
            for (ModelExtensionClass classBean : model.getClasses()) {
                prefix = classBean.getName() + ".class.";
                this.appendMap(classBean.getTagValues(), prefix + "tagValue.", writer);
                this.appendSet(classBean.getStereotypes(), prefix + "stereotype", writer);
                for (ModelExtensionAttribute attributeBean : classBean.getAttributes()) {
                    prefix = classBean.getName() + ".attribute." + attributeBean.getName() + ".";
                    this.appendMap(attributeBean.getTagValues(), prefix + "tagValue.", writer);
                    this.appendSet(attributeBean.getStereotypes(), prefix + "stereotype", writer);
                }
            }
        }
    }

    private void appendMap(Map<String, String> map, String prefix, Writer writer) throws IOException {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if ("true".equals(entry.getValue())) continue;
                writer.append(prefix).append(entry.getKey()).append("=").append(entry.getValue()).append(this.eol);
            }
        }
    }

    private void appendSet(Set<String> set, String prefix, Writer writer) throws IOException {
        if (!set.isEmpty()) {
            writer.append(prefix).append("=").append(Joiner.on((String)",").join(set)).append(this.eol);
        }
    }
}

