/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.eugene.models.extension.io.ModelExtensionWriter;
import org.nuiton.eugene.models.extension.model.ModelExtension;
import org.nuiton.eugene.models.extension.model.ModelExtensionAttribute;
import org.nuiton.eugene.models.extension.model.ModelExtensionClass;
import org.nuiton.eugene.models.extension.model.ModelExtensionPackage;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;

class ModelExtensionWriterIniImpl
extends ModelExtensionWriter {
    private final String eol = System.lineSeparator();

    ModelExtensionWriterIniImpl() {
    }

    @Override
    public void write(ObjectModel model, Writer writer) throws IOException {
        if (model.getStereotypes().size() > 0 || model.getTagValues().size() > 0) {
            writer.append("[model]").append(this.eol);
            this.appendMap(model.getTagValues(), "", writer);
            this.appendSet(model.getStereotypes(), "", writer);
        }
        if (CollectionUtils.isNotEmpty(model.getPackages())) {
            for (ObjectModelPackage packageBean : model.getPackages()) {
                if (packageBean.getStereotypes().size() <= 0 && packageBean.getTagValues().size() <= 0) continue;
                writer.append(this.eol).append("[package ").append(packageBean.getName()).append("]").append(this.eol);
                this.appendMap(packageBean.getTagValues(), "", writer);
                this.appendSet(packageBean.getStereotypes(), "", writer);
            }
        }
        if (CollectionUtils.isNotEmpty(model.getClasses())) {
            for (ObjectModelClass classBean : model.getClasses()) {
                boolean addSection;
                boolean bl = addSection = classBean.getStereotypes().size() > 0 || classBean.getTagValues().size() > 0;
                if (!addSection) {
                    ObjectModelAttribute attributeBean;
                    Iterator<ObjectModelAttribute> iterator = classBean.getAttributes().iterator();
                    while (iterator.hasNext() && !(addSection = (attributeBean = iterator.next()).getStereotypes().size() > 0 || attributeBean.getTagValues().size() > 0)) {
                    }
                }
                if (!addSection) continue;
                writer.append(this.eol).append("[class ").append(classBean.getName()).append("]").append(this.eol);
                this.appendMap(classBean.getTagValues(), "", writer);
                this.appendSet(classBean.getStereotypes(), "", writer);
                for (ObjectModelAttribute attributeBean : classBean.getAttributes()) {
                    this.appendMap(attributeBean.getTagValues(), attributeBean.getName() + ".", writer);
                    this.appendSet(attributeBean.getStereotypes(), attributeBean.getName() + ".", writer);
                }
            }
        }
    }

    @Override
    public void write(ModelExtension model, Writer writer) throws IOException {
        writer.append("[model]").append(this.eol);
        this.appendMap(model.getTagValues(), "", writer);
        if (model.withPackages()) {
            for (ModelExtensionPackage modelExtensionPackage : model.getPackages()) {
                writer.append(this.eol).append("[package ").append(modelExtensionPackage.getName()).append("]").append(this.eol);
                this.appendMap(modelExtensionPackage.getTagValues(), "", writer);
            }
        }
        if (model.withClasses()) {
            for (ModelExtensionClass modelExtensionClass : model.getClasses()) {
                writer.append(this.eol).append("[class ").append(modelExtensionClass.getName()).append("]").append(this.eol);
                this.appendMap(modelExtensionClass.getTagValues(), "", writer);
                for (ModelExtensionAttribute modelExtensionAttribute : modelExtensionClass.getAttributes()) {
                    this.appendMap(modelExtensionAttribute.getTagValues(), modelExtensionAttribute.getName() + ".", writer);
                }
            }
        }
    }

    private void appendMap(Map<String, String> map, String prefix, Writer writer) throws IOException {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                writer.append(prefix).append(entry.getKey()).append(" = ").append(entry.getValue()).append(this.eol);
            }
        }
    }

    private void appendSet(Set<String> set, String prefix, Writer writer) throws IOException {
        if (!set.isEmpty()) {
            for (String s : set) {
                writer.append(prefix).append(s).append(" = true").append(this.eol);
            }
        }
    }
}

