/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.io;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParser;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParserCallback;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.MismatchTagValueTargetException;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueNotFoundException;
import org.nuiton.eugene.models.extension.tagvalue.provider.AggregateTagValueMetadatasProvider;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelAssociationClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.tagvalue.TagValuesStore;

public class ModelExtensionReader
implements ModelExtensionFileParserCallback {
    private static final Logger log = LogManager.getLogger(ModelExtensionReader.class);
    protected final boolean verbose;
    protected final boolean strictLoading;
    protected final ObjectModel model;
    protected final TagValueMetadatasProvider tagValueMetadatasProvider;
    protected final TagValuesStore tagValuesStore;

    public ModelExtensionReader(boolean verbose, boolean strictLoading, ObjectModel model) {
        this.verbose = verbose;
        this.strictLoading = strictLoading;
        this.model = model;
        this.tagValueMetadatasProvider = new AggregateTagValueMetadatasProvider((ClassLoader)null);
        this.tagValuesStore = model.getTagValuesStore().getStore();
    }

    public void read(File modelExtension) throws IOException, InvalidTagValueSyntaxException, InvalidStereotypeSyntaxException {
        ModelExtensionFileParser parser = ModelExtensionFileParser.newParser(this.strictLoading, modelExtension);
        parser.parse(modelExtension, this);
    }

    @Override
    public boolean onModelTagValueFound(String tag, String value) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(tag, ObjectModel.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid model tag value: the tag-value '%s' is unknown.", tag);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid model tag value: this tag-value '%s' can not be apply on the model.", tag);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(tag).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated tagValue usage: %s", value));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelImpl modelImpl = (ObjectModelImpl)this.model;
        if (tag.equals(EugeneCoreTagValues.Store.version.getName())) {
            modelImpl.setVersion(value);
        }
        if (this.verbose) {
            log.info(String.format("model tag value imported %s \u2192 %s", tag, value));
        }
        modelImpl.addTagValue(tag, value);
        this.tagValuesStore.setModelTagValue(this.model.getName(), tag, value);
        return safe;
    }

    @Override
    public boolean onModelStereotypeFound(String stereotype) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(stereotype, ObjectModel.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid model stereotype [%s] : the stereotype '%s' is unknown.", stereotype, stereotype);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid model stereotype [%s] : this stereotype '%s' can not be apply on model.", stereotype, stereotype);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(stereotype).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated model stereotype usage: %s", stereotype));
            }
        } else if (this.strictLoading) {
            return false;
        }
        this.model.addTagValue(stereotype, "true");
        this.tagValuesStore.setModelTagValue(this.model.getName(), stereotype, "true");
        if (this.verbose) {
            log.info(String.format("stereotype imported %s \u2192 model.", stereotype));
        }
        return safe;
    }

    @Override
    public boolean onPackageTagValueFound(String packageName, String tag, String value) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(tag, ObjectModelPackage.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid tag value on package [%s]: the tag-value '%s' is unknown.", packageName, tag);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid tag value on package [%s]: this tag-value '%s' can not be apply on the model.", packageName, tag);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(tag).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated tagValue usage on package [%s]: %s", packageName, value));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelPackage omc = this.model.getPackage(packageName);
        if (this.verbose) {
            log.info(String.format("imported tag value on package [%s] \u2192 %s = %s", packageName, tag, value));
        }
        omc.addTagValue(tag, value);
        this.tagValuesStore.setPackageTagValue(packageName, tag, value);
        return true;
    }

    @Override
    public boolean onPackageStereotypeFound(String packageName, String stereotype) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(stereotype, ObjectModelPackage.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid model stereotype on package [%s]: the stereotype '%s' is unknown.", packageName, stereotype);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid model stereotype on package [%s]: this stereotype '%s' can not be apply on package.", packageName, stereotype);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(stereotype).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated stereotype usage on package [%s]: %s", packageName, stereotype));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelPackage omc = this.model.getPackage(packageName);
        if (omc == null) {
            return false;
        }
        omc.addTagValue(stereotype, "true");
        this.tagValuesStore.setPackageTagValue(packageName, stereotype, "true");
        if (this.verbose) {
            log.info(String.format("imported stereotype on package [%s] \u2192 %s", packageName, stereotype));
        }
        return true;
    }

    @Override
    public boolean onClassTagValueFound(String className, String tag, String value) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(tag, ObjectModelClass.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid tag value on class [%s]: this tag-value '%s' is unknown.", className, tag);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid tag value on class [%s]: this tag-value '%s' can not be apply on class scope.", className, tag);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(tag).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated tagValue usage on class [%s] : %s", className, value));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelClassifier omc = this.getClassifier(className);
        if (omc == null) {
            return false;
        }
        omc.addTagValue(tag, value);
        this.tagValuesStore.setClassifierTagValue(className, tag, value);
        if (this.verbose) {
            log.info(String.format("tag value imported on class [%s] \u2192 %s = %s", className, tag, value));
        }
        return true;
    }

    @Override
    public boolean onClassStereotypeFound(String className, String stereotype) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(stereotype, ObjectModelClassifier.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid model stereotype on class [%s]: the stereotype '%s' is unknown.", className, stereotype);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid model stereotype on class [%s]: this stereotype '%s' can not be apply on class scope.", className, stereotype);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(stereotype).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated stereotype usage on class [%s]: %s", className, stereotype));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelClassifier omc = this.getClassifier(className);
        if (omc == null) {
            return false;
        }
        omc.addTagValue(stereotype, "true");
        this.tagValuesStore.setClassifierTagValue(className, stereotype, "true");
        if (this.verbose) {
            log.info(String.format("stereotype imported on class [%s] \u2192 %s", className, stereotype));
        }
        return true;
    }

    @Override
    public boolean onAttributeTagValueFound(String className, String attributeName, String tag, String value) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(tag, ObjectModelAttribute.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid tag value on attribute [%s#%s]: this tag-value '%s' is unknown.", className, attributeName, tag);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid tag value on attribute [%s#%s]: this tag-value '%s' can not be apply on attribute scope.", className, attributeName, tag);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(tag).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated tagValue usage on attribute [%s#%s] : %s", className, attributeName, value));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelClassifier omc = this.getClassifier(className);
        if (omc == null) {
            return false;
        }
        ObjectModelAttribute attribute = this.getAttribute(omc, attributeName);
        if (attribute == null) {
            attribute = this.getInheritedAttribute(omc, attributeName);
            if (attribute == null) {
                return false;
            }
        } else {
            attribute.addTagValue(tag, value);
        }
        this.tagValuesStore.setAttributeTagValue(className, attributeName, tag, value);
        if (this.verbose) {
            log.info(String.format("tag value imported on attribute [%s#%s] \u2192 %s = %s", className, attributeName, tag, value));
        }
        return true;
    }

    @Override
    public boolean onAttributeStereotypeFound(String className, String attributeName, String stereotype) {
        String message;
        boolean safe = false;
        try {
            this.tagValueMetadatasProvider.validate(stereotype, ObjectModelAttribute.class);
            safe = true;
        }
        catch (TagValueNotFoundException e) {
            message = String.format("Invalid model stereotype on attribute [%s#%s]: the stereotype '%s' is unknown.", className, attributeName, stereotype);
            if (this.strictLoading) {
                log.error(message);
            } else {
                log.warn(message);
            }
        }
        catch (MismatchTagValueTargetException e) {
            message = String.format("Invalid model stereotype on attribute [%s#%s]: this stereotype '%s' can not be apply on attribute scope.", className, attributeName, stereotype);
            if (this.strictLoading) {
                log.error(message);
            }
            log.warn(message);
        }
        if (safe) {
            TagValueMetadata tagValueMetadata = (TagValueMetadata)this.tagValueMetadatasProvider.getTagValue(stereotype).toJavaUtil().orElseThrow();
            boolean deprecated = tagValueMetadata.isDeprecated();
            if (deprecated) {
                log.warn(String.format("Deprecated stereotype usage on attribute [%s]: %s", className, stereotype));
            }
        } else if (this.strictLoading) {
            return false;
        }
        ObjectModelClassifier omc = this.getClassifier(className);
        if (omc == null) {
            return false;
        }
        ObjectModelAttribute attribute = this.getAttribute(omc, attributeName);
        if (attribute == null) {
            return false;
        }
        attribute.addStereotype(stereotype);
        this.tagValuesStore.setAttributeTagValue(className, attributeName, stereotype, "true");
        if (this.verbose) {
            log.info(String.format("stereotype imported on attribute [%s#%s] \u2192 %s", className, attributeName, stereotype));
        }
        return true;
    }

    protected ObjectModelClassifier getClassifier(String fqn) {
        ObjectModelClassifier omc = this.model.getClassifier(fqn);
        if (omc == null) {
            if (log.isWarnEnabled()) {
                log.warn("Could not find classifier for " + fqn);
            }
            return null;
        }
        if (!(omc instanceof ObjectModelClassifierImpl)) {
            if (log.isWarnEnabled()) {
                log.warn("Can't add properties to model, it's not an ObjectModelClassifierImpl : " + omc.getQualifiedName());
            }
            return null;
        }
        return omc;
    }

    protected ObjectModelAttribute getAttribute(ObjectModelClassifier clazz, String name) {
        ObjectModelAttribute result = clazz.getAttribute(name);
        if (result == null && clazz instanceof ObjectModelAssociationClassImpl) {
            if (log.isDebugEnabled()) {
                log.debug("Attribute " + name + " not found from " + clazz.getQualifiedName() + " association class. Will check participants...");
            }
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute participant : assoc.getParticipantsAttributes()) {
                if (!participant.getName().equals(name)) continue;
                result = participant;
                break;
            }
        }
        return result;
    }

    protected ObjectModelAttribute getInheritedAttribute(ObjectModelClassifier clazz, String name) {
        return clazz.getAllOtherAttributes().stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }
}

