/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.io;

import io.ultreia.java4all.util.RecursiveProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParser;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParserCallback;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.object.reader.InvalidModelPropertiesException;

class ModelExtensionFileParserPropertiesImpl
extends ModelExtensionFileParser {
    private static final Logger log = LogManager.getLogger(ModelExtensionFileParserPropertiesImpl.class);
    protected final boolean strictLoading;

    public ModelExtensionFileParserPropertiesImpl(boolean strictLoading) {
        this.strictLoading = strictLoading;
    }

    @Override
    public void parse(File file, ModelExtensionFileParserCallback callback) throws IOException, InvalidStereotypeSyntaxException, InvalidTagValueSyntaxException {
        RecursiveProperties prop = new RecursiveProperties();
        try (InputStreamReader inStream = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            prop.load(inStream);
        }
        ArrayList keys = new ArrayList();
        CollectionUtils.addAll(keys, prop.stringPropertyNames());
        Collections.sort(keys);
        boolean safe = true;
        for (String key : keys) {
            String value;
            boolean thisSafe = this.consumeKeyValue(key, value = prop.getProperty(key), callback);
            if (thisSafe) continue;
            log.error(String.format("Unsafe tag-value: %s \u2192 %s", key, value));
            safe = false;
        }
        if (this.strictLoading && !safe) {
            String errorMessage = "There is some tag value(s) or stereotype(s) failed to be imported from " + file;
            throw new InvalidModelPropertiesException(errorMessage);
        }
    }

    protected boolean consumeKeyValue(String key, String value, ModelExtensionFileParserCallback callback) throws InvalidStereotypeSyntaxException, InvalidTagValueSyntaxException {
        boolean safe = true;
        boolean stereoTypeKey = this.isStereotype(key);
        boolean tagValueTypeKey = this.isTagValue(key);
        if (log.isDebugEnabled()) {
            log.debug("Property: '" + key + "' = " + value);
        }
        if (key.startsWith("model")) {
            if (stereoTypeKey) {
                Set<String> stereotypes = TagValueUtil.getStereotypes(value);
                for (String stereotype : stereotypes) {
                    safe &= callback.onModelStereotypeFound(stereotype);
                }
                return safe;
            }
            if (tagValueTypeKey) {
                Matcher matcher = TagValueUtil.getModelMatcher(key);
                String tag = matcher.group(2);
                return callback.onModelTagValueFound(tag, value);
            }
            throw new InvalidModelPropertiesException(key + " is not a valid model entry.");
        }
        if (key.startsWith("package")) {
            if (stereoTypeKey) {
                Matcher matcher = TagValueUtil.getPackageStereotypeMatcher(key);
                String fqn = matcher.group(1);
                fqn = StringUtils.substring((String)fqn, (int)0, (int)-1);
                Set<String> stereotypes = TagValueUtil.getStereotypes(value);
                for (String stereotype : stereotypes) {
                    safe &= callback.onPackageStereotypeFound(fqn, stereotype);
                }
                return safe;
            }
            if (tagValueTypeKey) {
                Matcher matcher = TagValueUtil.getPackageMatcher(key);
                String packageName = matcher.group(1);
                packageName = StringUtils.substring((String)packageName, (int)0, (int)-1);
                String tag = matcher.group(3);
                return callback.onPackageTagValueFound(packageName, tag, value);
            }
            throw new InvalidModelPropertiesException(key + " is not a valid package entry.");
        }
        if (stereoTypeKey) {
            Matcher matcher = TagValueUtil.getStereotypeMatcher(key);
            String fqn = matcher.group(1);
            fqn = StringUtils.substring((String)fqn, (int)0, (int)-1);
            String target = matcher.group(2);
            String targetName = matcher.group(3);
            Set<String> stereotypes = TagValueUtil.getStereotypes(value);
            for (String stereotype : stereotypes) {
                if ("class".equals(target)) {
                    safe &= callback.onClassStereotypeFound(fqn, stereotype);
                    continue;
                }
                if (!"attribute".equals(target)) continue;
                safe &= callback.onAttributeStereotypeFound(fqn, targetName, stereotype);
            }
            return safe;
        }
        if (tagValueTypeKey) {
            Matcher matcher = TagValueUtil.getMatcher(key);
            String fqn = matcher.group(1);
            fqn = StringUtils.substring((String)fqn, (int)0, (int)-1);
            String target = matcher.group(2);
            String targetName = matcher.group(3);
            String type = matcher.group(4).toLowerCase();
            String tag = matcher.group(5);
            if ("class".equals(target)) {
                return callback.onClassTagValueFound(fqn, tag, value);
            }
            if ("attribute".equals(target)) {
                return callback.onAttributeTagValueFound(fqn, targetName, tag, value);
            }
        }
        throw new InvalidModelPropertiesException(key + " is not a valid class or attribute entry.");
    }

    protected boolean isTagValue(String key) {
        return key.contains("tagvalue") || key.contains("tagValue");
    }

    protected boolean isStereotype(String key) {
        return key.contains("stereotype");
    }
}

