/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParser;
import org.nuiton.eugene.models.extension.io.ModelExtensionFileParserCallback;

class ModelExtensionFileParserIniImpl
extends ModelExtensionFileParser {
    protected final boolean strictLoading;

    public ModelExtensionFileParserIniImpl(boolean strictLoading) {
        this.strictLoading = strictLoading;
    }

    @Override
    public void parse(File file, ModelExtensionFileParserCallback callback) throws IOException {
        INIConfiguration iniConfiguration = new INIConfiguration();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            iniConfiguration.read((Reader)reader);
        }
        catch (ConfigurationException e) {
            throw new IOException("Could not read ini configuration from file: " + file, e);
        }
        SubnodeConfiguration modelSection = iniConfiguration.getSection("model");
        Iterator modelSectionKeys = modelSection.getKeys();
        while (modelSectionKeys.hasNext()) {
            String key = (String)modelSectionKeys.next();
            String value = modelSection.getString(key);
            key = key.replaceAll("\\.\\.", ".");
            if ("true".equals(value)) {
                callback.onModelStereotypeFound(key);
                continue;
            }
            callback.onModelTagValueFound(key, value);
        }
        for (String sectionName : iniConfiguration.getSections()) {
            String value;
            String key;
            Iterator keys;
            if (sectionName == null) continue;
            SubnodeConfiguration section = iniConfiguration.getSection(sectionName);
            if (sectionName.startsWith("package ")) {
                String packageName = StringUtils.removeStart((String)sectionName, (String)"package ");
                keys = section.getKeys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    value = section.getString(key);
                    key = key.replaceAll("\\.\\.", ".");
                    if ("true".equals(value)) {
                        callback.onPackageStereotypeFound(packageName, key);
                        continue;
                    }
                    callback.onPackageTagValueFound(packageName, key, value);
                }
                continue;
            }
            if (!sectionName.startsWith("class ")) continue;
            String className = StringUtils.removeStart((String)sectionName, (String)"class ");
            keys = section.getKeys();
            while (keys.hasNext()) {
                int attributeIndex;
                key = (String)keys.next();
                value = section.getString(key);
                key = key.replaceAll("\\.\\.", ".");
                if ("true".equals(value)) {
                    attributeIndex = key.indexOf(46);
                    if (attributeIndex == -1) {
                        callback.onClassStereotypeFound(className, key);
                        continue;
                    }
                    callback.onAttributeStereotypeFound(className, key.substring(0, attributeIndex), key.substring(attributeIndex + 1));
                    continue;
                }
                attributeIndex = key.indexOf(46);
                if (attributeIndex == -1) {
                    callback.onClassTagValueFound(className, key, value);
                    continue;
                }
                callback.onAttributeTagValueFound(className, key.substring(0, attributeIndex), key.substring(attributeIndex + 1), value);
            }
        }
    }
}

