/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java.extension;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.java.extension.CodesManager;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class CodesManagerExtension {
    private static final Logger log = LogManager.getLogger(CodesManagerExtension.class);
    public static final String OBJECTMODEL_EXTENSION = "codes";
    protected Map<String, CodesManager> managers;

    public void addcode(ObjectModelClassifier classifier, ObjectModelOperation operation, String code) {
        CodesManager codesManager = this.getManager(classifier);
        codesManager.addCode(operation, code);
    }

    public String getCode(ObjectModelClassifier classifier, ObjectModelOperation operation) {
        CodesManager manager = this.getManager(classifier);
        return manager.getCode(operation);
    }

    public CodesManager getManager(ObjectModelClassifier classifier) {
        String fqn;
        Map<String, CodesManager> managers = this.getManagers();
        CodesManager manager = managers.get(fqn = classifier.getQualifiedName());
        if (manager == null) {
            manager = new CodesManager();
            managers.put(fqn, manager);
            if (log.isDebugEnabled()) {
                log.debug("Add new codesManager for : " + fqn);
            }
        }
        return manager;
    }

    protected Map<String, CodesManager> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, CodesManager>();
        }
        return this.managers;
    }
}

