/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;

public class ServiceLoaderUtil {
    public static List<String> load(Path classPathDirectory, Class<?> type) {
        Path filePath = ServiceLoaderUtil.getServiceLoaderFile(classPathDirectory, type);
        try {
            return Files.exists(filePath, new LinkOption[0]) ? Files.readAllLines(filePath) : Collections.emptyList();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't load service loader file at: " + filePath, e);
        }
    }

    public static boolean store(Path classPathDirectory, Class<?> type, List<String> implementations) {
        List<String> load = ServiceLoaderUtil.load(classPathDirectory, type);
        if (load.equals(implementations)) {
            return false;
        }
        Path filePath = ServiceLoaderUtil.getServiceLoaderFile(classPathDirectory, type);
        try {
            if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            Files.write(filePath, implementations, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't store service loader file at: " + filePath, e);
        }
    }

    public static Path getServiceLoaderFile(Path classPathDirectory, Class<?> type) {
        return classPathDirectory.resolve("META-INF").resolve("services").resolve(type.getName());
    }
}

