/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.extension.AnnotationsManager;
import org.nuiton.eugene.java.extension.AnnotationsManagerExtension;
import org.nuiton.eugene.java.extension.CodesManager;
import org.nuiton.eugene.java.extension.CodesManagerExtension;
import org.nuiton.eugene.java.extension.ConstantsManagerExtension;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.nuiton.eugene.java.extension.ImportsManagerExtension;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.java.extension.ObjectModelAnnotationParameter;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelBuilder;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;

public class JavaBuilder
extends ObjectModelBuilder {
    private static final Logger log = LogManager.getLogger(JavaBuilder.class);
    protected ImportsManagerExtension importsManagerExtension = this.getModel().getExtension("imports", ImportsManagerExtension.class);
    protected AnnotationsManagerExtension annotationsManagerExtension = this.getModel().getExtension("annotations", AnnotationsManagerExtension.class);
    protected ConstantsManagerExtension constantsManagerExtension = this.getModel().getExtension("constants", ConstantsManagerExtension.class);
    protected CodesManagerExtension codesManagerExtension = this.getModel().getExtension("codes", CodesManagerExtension.class);

    public JavaBuilder(String modelName) {
        super(modelName);
    }

    @Override
    public void addInterface(ObjectModelClassifier classifier, String interfaceQualifiedName) {
        super.addInterface(classifier, interfaceQualifiedName);
        this.addImport(classifier, interfaceQualifiedName);
    }

    @Override
    public void addSuperclass(ObjectModelClass clazz, String superclassQualifiedName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This operation can't be used to generate Java, use setSuperClass method instead");
    }

    @Override
    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier ... modifiers) {
        this.addImport(classifier, type);
        return super.addAttribute(classifier, name, type, value, modifiers);
    }

    @Override
    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type) {
        return this.addAttribute(classifier, name, type, "", ObjectModelJavaModifier.PROTECTED);
    }

    @Override
    public ObjectModelOperation addOperation(ObjectModelClassifier classifier, String name, String type, ObjectModelModifier ... modifiers) {
        this.addImport(classifier, type);
        return super.addOperation(classifier, name, type, modifiers);
    }

    @Override
    public ObjectModelParameter addParameter(ObjectModelOperation operation, String type, String name) {
        this.addImport((ObjectModelClassifier)operation.getDeclaringElement(), type);
        return super.addParameter(operation, type, name);
    }

    @Override
    public void addException(ObjectModelOperation operation, String exception) {
        this.addImport((ObjectModelClassifier)operation.getDeclaringElement(), exception);
        super.addException(operation, exception);
    }

    @Override
    public void setOperationBody(ObjectModelOperation operation, String body) throws IllegalArgumentException {
        if (operation.isAbstract()) {
            throw new IllegalArgumentException("Unable to add body for an abstract method");
        }
        super.setOperationBody(operation, body);
    }

    public ObjectModelClass createAbstractClass(String name, String packageName) {
        return this.createClass(name, packageName, ObjectModelJavaModifier.ABSTRACT);
    }

    public void addImport(ObjectModelClassifier classifier, String imports) {
        if (imports == null) {
            return;
        }
        ImportsManager manager = this.getImportManager(classifier);
        if ((imports = imports.trim()).endsWith("...")) {
            imports = imports.substring(0, imports.length() - 3);
        }
        for (String oneType : GeneratorUtil.getTypesList(imports)) {
            manager.addImport(oneType);
            if (!log.isDebugEnabled()) continue;
            log.debug("Add import for : " + classifier.getQualifiedName() + " _ import: " + oneType);
        }
    }

    public String importAndSimplify(ObjectModelClassifier classifier, String imports) {
        ImportsManager manager = this.getImportManager(Objects.requireNonNull(classifier));
        if ((imports = Objects.requireNonNull(imports).trim()).endsWith("...")) {
            imports = imports.substring(0, imports.length() - 3);
            return this.importAndSimplify(classifier, imports) + "...";
        }
        Set<String> typesList = GeneratorUtil.getTypesList(imports);
        if (typesList.size() > 1) {
            typesList.forEach(manager::addImport);
            return imports;
        }
        String oneType = typesList.iterator().next();
        return manager.importAndSimplify(oneType);
    }

    public ObjectModelAnnotation addAnnotation(ObjectModelClassifier classifier, ObjectModelElement element, String annotationType) {
        Preconditions.checkNotNull((Object)"Can't add a null annotation");
        Preconditions.checkArgument((boolean)SourceVersion.isName(annotationType), (Object)("Annotation type must be a valid type , but was: " + annotationType));
        AnnotationsManager manager = this.annotationsManagerExtension.getManager(classifier);
        ObjectModelAnnotation annotation = new ObjectModelAnnotation(annotationType);
        manager.addAnnotation(element, annotation);
        if (log.isDebugEnabled()) {
            log.debug("Add annotation for <" + classifier.getQualifiedName() + ":" + element.getName() + ">  : " + annotation);
        }
        return annotation;
    }

    public ObjectModelAnnotation addAnnotationParameter(ObjectModelAnnotation annotation, String parameterName, Object parameterValue) {
        annotation.addParameter(new ObjectModelAnnotationParameter(parameterName, parameterValue));
        return annotation;
    }

    public void setSuperClass(ObjectModelClass classifier, String superclassQualifiedName) {
        ObjectModelClassImpl impl = (ObjectModelClassImpl)classifier;
        impl.clearSuperclasses();
        super.addSuperclass(impl, superclassQualifiedName);
        this.addImport(classifier, superclassQualifiedName);
    }

    public ObjectModelAttribute addConstant(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier visibility) throws IllegalArgumentException {
        if (!visibility.isVisibility()) {
            throw new IllegalArgumentException("Illegal visibility type : " + visibility.toString() + " for " + classifier.getQualifiedName());
        }
        return this.addAttribute(classifier, name, type, value, visibility, ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.FINAL);
    }

    public void addBodyCode(ObjectModelClassifier classifier, ObjectModelOperation operation, String code) {
        if (code == null) {
            return;
        }
        CodesManager manager = this.codesManagerExtension.getManager(classifier);
        code = code.trim();
        manager.addCode(operation, code);
        if (log.isDebugEnabled()) {
            log.debug("Add code for <" + classifier.getQualifiedName() + ":" + operation.getName() + ">  : " + code);
        }
    }

    public String getConstantName(String propertyName) {
        String result = this.constantsManagerExtension.getConstantName(propertyName);
        if (log.isDebugEnabled()) {
            log.debug("get constant name for <" + propertyName + ">  : " + result);
        }
        return result;
    }

    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, ObjectModelAttribute attribute) {
        HashSet<ObjectModelJavaModifier> modifiers = new HashSet<ObjectModelJavaModifier>();
        if (attribute.isStatic()) {
            modifiers.add(ObjectModelJavaModifier.STATIC);
        }
        if (attribute.isFinal()) {
            modifiers.add(ObjectModelJavaModifier.FINAL);
        }
        if (attribute.isTransient()) {
            modifiers.add(ObjectModelJavaModifier.TRANSIENT);
        }
        modifiers.add(ObjectModelJavaModifier.fromVisibility(attribute.getVisibility()));
        return this.addAttribute(classifier, attribute.getName(), attribute.getType(), attribute.getDefaultValue(), modifiers.toArray(new ObjectModelModifier[modifiers.size()]));
    }

    public ObjectModelOperation addBlock(ObjectModelClassifier classifier, ObjectModelModifier ... modifiers) {
        ObjectModelOperationImpl operation = (ObjectModelOperationImpl)this.addOperation(classifier, null, null, modifiers);
        if (Arrays.asList(modifiers).contains(ObjectModelJavaModifier.STATIC)) {
            operation.setStatic(true);
        }
        return operation;
    }

    public ObjectModelOperation addConstructor(ObjectModelClass clazz, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.addConstructorForClassifier(clazz, visibility);
    }

    public ObjectModelOperation addConstructor(ObjectModelEnumeration enumeration, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.addConstructorForClassifier(enumeration, visibility);
    }

    protected ObjectModelOperation addConstructorForClassifier(ObjectModelClassifier classifier, ObjectModelModifier visibility) {
        if (!visibility.isVisibility()) {
            throw new IllegalArgumentException("Illegal visibility type : " + visibility.toString() + " for " + classifier.getQualifiedName());
        }
        String simpleName = JavaGeneratorUtil.removeAnyGenericDefinition(classifier.getName());
        return this.addOperation(classifier, simpleName, null, visibility);
    }

    public ImportsManager getImportManager(ObjectModelClassifier clazz) {
        return this.importsManagerExtension.getManager(clazz);
    }
}

