/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.DefaultTemplateConfiguration;
import org.nuiton.eugene.LogProxy;
import org.nuiton.eugene.ResourcesHelper;
import org.nuiton.eugene.TemplateConfiguration;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.writer.WriterReport;

public abstract class Template<M extends Model>
implements TemplateConfiguration {
    protected TemplateConfiguration configuration;
    protected List<String> excludeTemplates;
    protected List<String> generatedPackages;
    protected M model;
    protected ResourcesHelper resourcesHelper;
    private LogProxy log;

    protected LogProxy getLog() {
        return this.log;
    }

    public void setLog(LogProxy log) {
        this.log = log;
    }

    public abstract void applyTemplate(M var1, File var2) throws IOException;

    public TemplateConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new DefaultTemplateConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(TemplateConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public boolean getOverwrite() {
        return this.isOverwrite();
    }

    @Override
    public boolean isOverwrite() {
        return this.getConfiguration().isOverwrite();
    }

    @Override
    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    @Override
    public String getEncoding() {
        return this.getConfiguration().getEncoding();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getConfiguration().getClassLoader();
    }

    @Override
    public long getLastModifiedSource() {
        return this.getConfiguration().getLastModifiedSource();
    }

    @Override
    public Properties getProperties() {
        return this.getConfiguration().getProperties();
    }

    @Override
    public <V> V getProperty(String key, Class<V> type) {
        return this.getConfiguration().getProperty(key, type);
    }

    @Override
    public String getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    @Override
    public WriterReport getWriterReport() {
        return this.getConfiguration().getWriterReport();
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getConfiguration().setProperty(key, value);
        if ("generatedPackages".equals(key)) {
            this.generatedPackages = null;
        } else if ("excludeTemplates".equals(key)) {
            this.excludeTemplates = null;
        }
    }

    protected List<String> getGeneratedPackages() {
        if (this.generatedPackages == null) {
            this.generatedPackages = new ArrayList<String>();
            String genPackages = this.getProperty("generatedPackages");
            if (!StringUtils.isEmpty((CharSequence)genPackages)) {
                this.generatedPackages.addAll(Arrays.asList(genPackages.split(",")));
            }
        }
        return this.generatedPackages;
    }

    public List<String> getExcludeTemplates() {
        if (this.excludeTemplates == null) {
            this.excludeTemplates = new ArrayList<String>();
            String excludes = this.getProperty("excludeTemplates");
            if (!StringUtils.isEmpty((CharSequence)excludes)) {
                this.excludeTemplates.addAll(Arrays.asList(excludes.split(",")));
            }
        }
        return this.excludeTemplates;
    }

    public M getModel() {
        return this.model;
    }

    protected ResourcesHelper getResourcesHelper() {
        if (this.resourcesHelper == null) {
            File outputDirectory = this.getConfiguration().getProperty("outputDirectory", File.class);
            this.resourcesHelper = new ResourcesHelper(this.getClassLoader(), outputDirectory, this.isVerbose());
        }
        return this.resourcesHelper;
    }
}

