/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

public class PackageValidator {
    public static boolean toContinue(String fullPackagePath, String localPackageNameDot, String extraPackages) {
        if (fullPackagePath.startsWith(localPackageNameDot)) {
            return true;
        }
        String[] packages = extraPackages.split(",");
        for (int i = 0; i < packages.length; ++i) {
            packages[i] = packages[i].trim();
            if (!packages[i].startsWith(localPackageNameDot)) continue;
            return localPackageNameDot.length() < packages[i].lastIndexOf(".") + 1;
        }
        return false;
    }

    public static boolean isValid(String fullPackagePath, String localPackageName, String extraPackages) {
        if (localPackageName.startsWith(fullPackagePath)) {
            return true;
        }
        if (localPackageName.length() == 0) {
            return false;
        }
        String[] packages = extraPackages.split(",");
        for (int i = 0; i < packages.length; ++i) {
            packages[i] = packages[i].trim();
            if (!localPackageName.matches(packages[i]) && !packages[i].startsWith(localPackageName)) continue;
            return true;
        }
        return false;
    }
}

