/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.util.Collections;
import java.util.Map;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.Model;

public class ModelHelper {
    protected Map<String, Model> models;
    protected Map<String, ModelReader<?>> modelReaders;

    public ModelHelper(Map<String, Model> models, Map<String, ModelReader<?>> modelReaders) {
        this.models = Collections.unmodifiableMap(models);
        this.modelReaders = Collections.unmodifiableMap(modelReaders);
    }

    public Model getModel(String modelType) {
        Model model = this.models.get(modelType.trim());
        return model;
    }

    public ModelReader getModelReader(String modelType, String type) {
        ModelReader<?> result = null;
        for (ModelReader<?> modelReader : this.modelReaders.values()) {
            if (!modelType.equals(modelReader.getModelType()) || !type.equals(modelReader.getInputType())) continue;
            result = modelReader;
            break;
        }
        return result;
    }

    public Map<String, ModelReader<?>> getModelReaders() {
        return this.modelReaders;
    }

    public static enum ModelInputType {
        XML("xml"),
        YAML("yaml"),
        FRIEND("friend");

        private final String alias;

        private ModelInputType(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static enum ModelType {
        OBJECT("objectmodel"),
        STATE("statemodel");

        private final String alias;

        private ModelType(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

