/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.SerialVersionUIDBuilder;

public class GeneratorUtil {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static String getParentPackageName(String packageName) {
        String parentPackageName = packageName;
        int index = packageName.lastIndexOf(46);
        if (index != -1) {
            parentPackageName = packageName.substring(0, index);
        }
        return parentPackageName;
    }

    public static String getClassNameFromQualifiedName(String qualifiedName) {
        String className = qualifiedName;
        int index = qualifiedName.lastIndexOf(46);
        if (index != -1) {
            className = qualifiedName.substring(index + 1);
        }
        return className;
    }

    public static String getFilenameFromQualifiedName(String qualifiedName) {
        return qualifiedName.replace('.', File.separatorChar);
    }

    public static Collection<ObjectModelClassifier> getClassifiers(ObjectModel model, String packageName) {
        ArrayList<ObjectModelClassifier> classifiers = new ArrayList<ObjectModelClassifier>();
        for (ObjectModelClassifier classifier : model.getClassifiers()) {
            if (!classifier.getPackageName().startsWith(packageName)) continue;
            classifiers.add(classifier);
        }
        return classifiers;
    }

    public static boolean isPrimitiveAttributeType(ObjectModelAttribute attribute) {
        if (GeneratorUtil.isNMultiplicity(attribute)) {
            return false;
        }
        String type = attribute.getType();
        return GeneratorUtil.isPrimitiveType(type);
    }

    public static boolean isPrimitiveType(String type) {
        return "byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "char".equals(type) || "boolean".equals(type);
    }

    public static String getPrimitiveWrapType(String type) {
        if ("byte".equals(type)) {
            return "Byte";
        }
        if ("short".equals(type)) {
            return "Short";
        }
        if ("int".equals(type)) {
            return "Integer";
        }
        if ("long".equals(type)) {
            return "Long";
        }
        if ("float".equals(type)) {
            return "Float";
        }
        if ("double".equals(type)) {
            return "Double";
        }
        if ("char".equals(type)) {
            return "Character";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        return null;
    }

    public static String getInitValue(ObjectModelAttribute attribute) {
        if (GeneratorUtil.isNMultiplicity(attribute)) {
            return "new java.util.ArrayList()";
        }
        return GeneratorUtil.getInitValue(attribute.getType());
    }

    public static String getInitValue(String type) {
        if ("byte".equals(type)) {
            return "0";
        }
        if ("short".equals(type)) {
            return "0";
        }
        if ("int".equals(type)) {
            return "0";
        }
        if ("long".equals(type)) {
            return "0";
        }
        if ("float".equals(type)) {
            return "0";
        }
        if ("double".equals(type)) {
            return "0";
        }
        if ("char".equals(type)) {
            return "\u0000";
        }
        if ("boolean".equals(type)) {
            return "false";
        }
        if ("java.lang.String".equals(type)) {
            return null;
        }
        if ("java.lang.Date".equals(type)) {
            return null;
        }
        return null;
    }

    public static String getCastValue(String type, String o) {
        if ("byte".equals(type)) {
            return "((Byte)" + o + ").byteValue()";
        }
        if ("short".equals(type)) {
            return "((Short)" + o + ").shortValue()";
        }
        if ("int".equals(type)) {
            return "((Integer)" + o + ").intValue()";
        }
        if ("long".equals(type)) {
            return "((Long)" + o + ").longValue()";
        }
        if ("float".equals(type)) {
            return "((Float)" + o + ").floatValue()";
        }
        if ("double".equals(type)) {
            return "((Double)" + o + ").doubleValue()";
        }
        if ("char".equals(type)) {
            return "((Character)" + o + ").charValue()";
        }
        if ("boolean".equals(type)) {
            return "((Boolean)" + o + ").booleanValue()";
        }
        if ("void".equals(type)) {
            return "";
        }
        return "(" + type + ")" + o;
    }

    public static String getHashCodeExpression(String type, String o) {
        Object result = o;
        if ("byte".equals(type)) {
            result = "new Byte(" + o + ")";
        }
        if ("short".equals(type)) {
            result = "new Short(" + o + ")";
        }
        if ("int".equals(type)) {
            result = "new Integer(" + o + ")";
        }
        if ("long".equals(type)) {
            result = "new Long(" + o + ")";
        }
        if ("float".equals(type)) {
            result = "new Float(" + o + ")";
        }
        if ("double".equals(type)) {
            result = "new Double(" + o + ")";
        }
        if ("char".equals(type)) {
            result = "new Character(" + o + ")";
        }
        if ("boolean".equals(type)) {
            result = "new Boolean(" + o + ")";
        }
        return (String)result + ".hashCode()";
    }

    public static boolean isNMultiplicity(ObjectModelAttribute attribute) {
        return GeneratorUtil.isNMultiplicity(attribute.getMaxMultiplicity());
    }

    public static boolean isNMultiplicity(int multiplicity) {
        return multiplicity == -1 || multiplicity > 1;
    }

    public static boolean isOneMultiplicity(ObjectModelAttribute attribute) {
        return attribute != null && attribute.getMinMultiplicity() == 1 && attribute.getMaxMultiplicity() == 1;
    }

    public static String toLowerCaseFirstLetter(String word) {
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }

    public static boolean isComposition(ObjectModelAttribute attribute) {
        boolean composition = false;
        if (attribute != null && attribute.getReverseAttribute() != null) {
            composition = attribute.getReverseAttribute().isComposite();
        }
        return composition;
    }

    public static boolean isBooleanPrimitive(ObjectModelAttribute attribute) {
        String type = attribute.getType();
        return GeneratorUtil.isBooleanPrimitive(type);
    }

    public static boolean isBooleanPrimitive(String type) {
        return "boolean".equals(type);
    }

    public static String getParsingExpression(String type, String attributeStringName) {
        if ("byte".equals(type)) {
            return "Byte.parseByte(" + attributeStringName + ")";
        }
        if ("short".equals(type)) {
            return "Short.parseShort(" + attributeStringName + ")";
        }
        if ("int".equals(type)) {
            return "Integer.parseInt(" + attributeStringName + ")";
        }
        if ("long".equals(type)) {
            return "Long.parseLong(" + attributeStringName + ")";
        }
        if ("float".equals(type)) {
            return "Float.parseFloat(" + attributeStringName + ")";
        }
        if ("double".equals(type)) {
            return "Double.parseDouble(" + attributeStringName + ")";
        }
        if ("char".equals(type)) {
            return attributeStringName + ".charAt(0)";
        }
        if ("boolean".equals(type)) {
            return "Boolean.parseBoolean(" + attributeStringName + ")";
        }
        if ("java.lang.String".equals(type)) {
            return attributeStringName;
        }
        if ("java.util.Date".equals(type)) {
            return "dateParser.parse(" + attributeStringName + ")";
        }
        return null;
    }

    public static String getFormatingExpression(String type, String attributeStringName) {
        if ("byte".equals(type)) {
            return "Byte.toString(" + attributeStringName + ")";
        }
        if ("short".equals(type)) {
            return "Short.toString(" + attributeStringName + ")";
        }
        if ("int".equals(type)) {
            return "Integer.toString(" + attributeStringName + ")";
        }
        if ("long".equals(type)) {
            return "Long.toString(" + attributeStringName + ")";
        }
        if ("float".equals(type)) {
            return "Float.toString(" + attributeStringName + ")";
        }
        if ("double".equals(type)) {
            return "Double.toString(" + attributeStringName + ")";
        }
        if ("char".equals(type)) {
            return "Character.toString(" + attributeStringName + ")";
        }
        if ("boolean".equals(type)) {
            return "Boolean.parseBoolean(" + attributeStringName + ")";
        }
        if ("java.lang.String".equals(type)) {
            return attributeStringName;
        }
        if ("java.util.Date".equals(type)) {
            return "dateParser.format(" + attributeStringName + ")";
        }
        return null;
    }

    public static String getOperationParametersListName(ObjectModelOperation operation) {
        return Joiner.on((String)", ").join((Iterable)operation.getParameters().stream().map(ObjectModelElement::getName).collect(Collectors.toList()));
    }

    public static boolean isFirstAttribute(ObjectModelAttribute attr) {
        boolean firstAttribute = true;
        if (attr.getReverseAttribute() != null) {
            firstAttribute = attr.getName().compareTo(attr.getReverseAttribute().getName()) < 0;
        }
        return firstAttribute;
    }

    public static boolean hasDocumentation(ObjectModelElement element) {
        return StringUtils.isNotEmpty((CharSequence)element.getDocumentation());
    }

    @Deprecated
    public static boolean notEmpty(String s) {
        return s != null && !"".equals(s);
    }

    @Deprecated
    public static String findTagValue(String tagName, ObjectModelElement element, Model model) {
        if (element == null) {
            String value;
            if (model != null && !StringUtils.isEmpty((CharSequence)(value = model.getTagValue(tagName)))) {
                return value;
            }
            return null;
        }
        String value = element.getTagValue(tagName);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return GeneratorUtil.findTagValue(tagName, element.getDeclaringElement(), model);
    }

    public static boolean hasStereotype(ObjectModelElement element, String stereotype) {
        return element.hasStereotype(stereotype) || element.hasStereotype(stereotype.toLowerCase());
    }

    @Deprecated
    public static String computeSerialVersionUID(ObjectModelClass clazz) {
        String query = clazz.getQualifiedName() + "#";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            query = query + "-" + attr.getType();
        }
        String result = query.hashCode() + "L";
        return result;
    }

    public static String getSimpleName(String str) {
        String result = GeneratorUtil.getSimpleName(str, false);
        return result;
    }

    public static String getSimpleName(String str, boolean removeGenericDefinition) {
        if (removeGenericDefinition) {
            str = GeneratorUtil.removeGenericDefinition(str);
        }
        boolean variableArrayType = false;
        if (str.endsWith("...")) {
            variableArrayType = true;
            str = str.substring(0, str.length() - 3);
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str;
        }
        Object result = str.replaceAll("\\p{Alpha}\\w*\\.", "");
        if (variableArrayType) {
            result = (String)result + "...";
        }
        return result;
    }

    public static String removeGenericDefinition(String str) {
        int i;
        String result = str.trim();
        if (!result.startsWith("<")) {
            return str;
        }
        int length = result.length();
        int count = 0;
        for (i = 0; i < length; ++i) {
            char c = result.charAt(i);
            if ('<' == c) {
                ++count;
            } else if ('>' == c) {
                --count;
            }
            if (count == 0) break;
        }
        result = result.substring(i + 1);
        while (result.startsWith(" ")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String removeAnyGenericDefinition(String str) {
        String result = str.trim();
        if (!result.contains("<")) {
            return str;
        }
        result = result.substring(0, result.indexOf(60));
        return result;
    }

    public static String[] splitGenericDefinition(String str) {
        int i;
        String result = str.trim();
        if (!result.startsWith("<")) {
            return new String[]{str};
        }
        int length = result.length();
        int count = 0;
        for (i = 0; i < length; ++i) {
            char c = result.charAt(i);
            if ('<' == c) {
                ++count;
            } else if ('>' == c) {
                --count;
            }
            if (count == 0) break;
        }
        String prefix = result.substring(0, i + 1);
        String end = result.substring(i + 1);
        while (end.startsWith(" ")) {
            end = end.substring(1);
        }
        return new String[]{prefix, end};
    }

    public static Set<String> getTypesList(String str) {
        String[] strArray;
        HashSet<String> results = new HashSet<String>();
        String localStr = str.replaceAll("([\\w\\?]+ extends|[\\w\\?]+ super|new)", "");
        localStr = localStr.replaceAll("[^\\w\\.]", " ");
        for (String strImport : strArray = localStr.split("\\s+")) {
            String localStrImport = strImport.trim();
            if (localStrImport.isEmpty()) continue;
            results.add(localStrImport);
        }
        return results;
    }

    public static boolean simpleNamesEquals(String first, String second) {
        return GeneratorUtil.removeAnyGenericDefinition(first).equals(GeneratorUtil.removeAnyGenericDefinition(second));
    }

    public static String convertVariableNameToConstantName(String variableName) {
        StringBuilder buffer = new StringBuilder();
        boolean lastCarIsUp = false;
        int j = variableName.length();
        for (int i = 0; i < j; ++i) {
            char c = variableName.charAt(i);
            boolean carIsUp = Character.isUpperCase(c);
            if (i > 0 && !lastCarIsUp && carIsUp) {
                buffer.append('_');
            }
            if (carIsUp) {
                buffer.append(c);
            } else {
                buffer.append(Character.toUpperCase(c));
            }
            lastCarIsUp = carIsUp;
        }
        return buffer.toString();
    }

    public static String convertConstantNameToVariableName(String constantName) {
        StringBuilder buffer = new StringBuilder();
        boolean lastCarIsUp = false;
        int j = constantName.length();
        for (int i = 0; i < j; ++i) {
            char c = constantName.charAt(i);
            if ('_' == c) {
                lastCarIsUp = true;
                continue;
            }
            if (lastCarIsUp) {
                c = Character.toUpperCase(c);
                lastCarIsUp = false;
            } else {
                c = Character.toLowerCase(c);
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String getAssocAttrName(ObjectModelAttribute attr) {
        String typeName = attr.getType().substring(attr.getType().lastIndexOf(".") + 1);
        Object result = attr.getName();
        if (attr.getName().equalsIgnoreCase(typeName)) {
            result = (String)result + StringUtils.capitalize((String)attr.getAssociationClass().getName());
        }
        return result;
    }

    public static long generateSerialVersionUID(ObjectModelClassifier classifier) {
        long result = SerialVersionUIDBuilder.computeDefaultSUID(classifier);
        return result;
    }

    public static File getRelativeFile(File inputDirectory, File outputDirectory, File file) {
        String inputPath = inputDirectory.getAbsolutePath();
        String s = file.getAbsolutePath();
        int index = s.indexOf(inputPath);
        if (index == -1) {
            throw new IllegalArgumentException("File " + file + " is not in " + inputDirectory);
        }
        String relativePath = s.substring(inputPath.length());
        File result = new File(outputDirectory, relativePath);
        return result;
    }

    public static File changeExtension(File file, String newExtension) throws IOException {
        String name = file.getName();
        String newName = GeneratorUtil.changeExtension(name, newExtension);
        return new File(file.getParentFile(), newName);
    }

    public static String changeExtension(String name, String newExtension) throws IOException {
        String extension = FilenameUtils.getExtension((String)name);
        if (extension == null) {
            throw new IOException(String.format("Could not find extension for name %s.", name));
        }
        String nameWithoutExtension = name.substring(0, name.length() - extension.length());
        return nameWithoutExtension + newExtension;
    }
}

