/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import io.ultreia.java4all.lang.Strings;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.ResourceResolver;

public class FasterCachedResourceResolver
extends ResourceResolver {
    private static final Logger log = LogManager.getLogger(FasterCachedResourceResolver.class);
    protected boolean offline;

    public FasterCachedResourceResolver() {
        this(null);
    }

    public FasterCachedResourceResolver(String base) {
        super(base);
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @Override
    protected Source findHrefSource(String path) {
        long t0 = System.nanoTime();
        String resource = "META-INF/cache/" + path;
        if (this.verbose) {
            log.info("will discover " + resource);
        }
        URL url = this.cl.getResource(resource);
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info(url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (source == null) {
            if (this.offline) {
                throw new IllegalStateException("offline - could not find extact resource at location " + resource);
            }
            log.warn("could not find extact resource at location " + resource);
        }
        if (this.verbose) {
            log.info("resolved in " + Strings.convertTime((long)(System.nanoTime() - t0)));
        }
        return source;
    }
}

