/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.I18n;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelPackage;

@Component(role=TagValueMetadatasProvider.class, hint="eugene")
public class EugeneCoreTagValues
extends DefaultTagValueMetadatasProvider {
    @Override
    public String getDescription() {
        return I18n.t((String)"eugene.core.tagvalues", (Object[])new Object[0]);
    }

    public EugeneCoreTagValues() {
        super(Store.values());
    }

    public String getDocumentationTagValue(ObjectModel model) {
        return TagValueUtil.findTagValue(Store.documentation, model);
    }

    public String getDocumentationTagValue(ObjectModelElement element) {
        return TagValueUtil.findTagValue(Store.documentation, element);
    }

    public String getDocumentationTagValue(ObjectModelPackage aPackage) {
        return TagValueUtil.findTagValue(Store.documentation, aPackage);
    }

    public String getI18nPrefixTagValue(ObjectModelElement element, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.i18n, element, aPackage, model);
    }

    public boolean isGenerateBooleanGetMethods(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.generateBooleanGetMethods, classifier, aPackage, model);
    }

    public String getConstantPrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.constantPrefix, classifier, aPackage, model);
    }

    public String getAttributeGenericTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue(Store.attributeGeneric, attribute);
    }

    public static boolean isOrdered(ObjectModelAttribute attribute) {
        return TagValueUtil.findBooleanTagValue(Store.ordered, attribute);
    }

    public static boolean isUnique(ObjectModelAttribute attribute) {
        return TagValueUtil.findBooleanTagValue(Store.unique, attribute);
    }

    public static String getDefaultValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findDirectTagValue(Store.defaultValue, attribute);
    }

    public static boolean isSkip(ObjectModelClassifier classifier, ObjectModelPackage aPackage) {
        return TagValueUtil.findBooleanTagValue(Store.skip, classifier, aPackage);
    }

    public static boolean isSkip(ObjectModelPackage aPackage) {
        return TagValueUtil.findBooleanTagValue(Store.skip, aPackage);
    }

    public String getDefaultPackage(ObjectModelElement element) {
        return TagValueUtil.findTagValue(Store.defaultPackage, element);
    }

    public Set<String> getConstants(ObjectModelClassifier classifier) {
        String notEmptyTagValue = TagValueUtil.findNotEmptyTagValue((TagValueMetadata)Store.constants, (WithTagValuesOrStereotypes)classifier);
        return notEmptyTagValue == null ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(notEmptyTagValue.split("\\s*,\\s*")));
    }

    public boolean isUseRelativeName(ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.useRelativeName, model);
    }

    public Set<String> getRelativeNameExcludes(ObjectModel model) {
        String notEmptyTagValue = TagValueUtil.findNotEmptyTagValue((TagValueMetadata)Store.relativeNameExcludes, (WithTagValuesOrStereotypes)model);
        return notEmptyTagValue == null ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(notEmptyTagValue.split("\\s*,\\s*")));
    }

    public static enum Store implements TagValueMetadata
    {
        version(I18n.n((String)"eugene.core.tagValues.version", (Object[])new Object[0]), String.class, null, ObjectModel.class),
        documentation(I18n.n((String)"eugene.core.tagValues.documentation", (Object[])new Object[0]), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelElement.class),
        constantPrefix(I18n.n((String)"eugene.core.tagValues.constantPrefix", (Object[])new Object[0]), String.class, "PROPERTY_", ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        i18n(I18n.n((String)"eugene.core.tagValues.i18n", (Object[])new Object[0]), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        generateBooleanGetMethods(I18n.n((String)"eugene.core.tagValues.generateBooleanGetMethods", (Object[])new Object[0]), Boolean.TYPE, "false", ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        attributeGeneric(I18n.n((String)"eugene.core.tagValues.attributeGeneric", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        ordered(I18n.n((String)"eugene.core.tagValues.ordered", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelAttribute.class),
        unique(I18n.n((String)"eugene.core.tagValues.unique", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelAttribute.class),
        defaultValue(I18n.n((String)"eugene.core.tagValues.defaultValue", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        skip(I18n.n((String)"eugene.core.tagValues.skip", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelClassifier.class, ObjectModelPackage.class),
        defaultPackage(I18n.n((String)"eugene.core.tagValues.defaultPackage", (Object[])new Object[0]), String.class, null, ObjectModel.class),
        constants(I18n.n((String)"eugene.java.tagvalue.constants", (Object[])new Object[0]), String[].class, null, ObjectModelClassifier.class),
        useRelativeName(I18n.n((String)"eugene.java.tagvalue.useRelativeName", (Object[])new Object[0]), Boolean.TYPE, "false", ObjectModel.class),
        relativeNameExcludes(I18n.n((String)"eugene.java.tagvalue.relativeNameExcludes", (Object[])new Object[0]), String[].class, null, ObjectModel.class);

        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String _defaultValue;

        private Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?> ... targets) {
            this.targets = ImmutableSet.copyOf((Object[])targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this._defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public Set<Class<?>> getTargets() {
            return this.targets;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        @Override
        public String getDescription() {
            return I18n.t((String)this.i18nDescriptionKey, (Object[])new Object[0]);
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }
}

