/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.Transformer;
import org.nuiton.eugene.models.Model;

public abstract class AbstractMetaTransformer<M extends Model>
extends AbstractGenerator<M> {
    private static final Logger log = LogManager.getLogger(AbstractMetaTransformer.class);
    protected Class<? extends Transformer<M, M>>[] transformerTypes;
    protected Class<? extends Template<M>>[] templateTypes;

    protected AbstractMetaTransformer() {
    }

    @Deprecated
    public AbstractMetaTransformer(Class<? extends Template<M>> ... templateTypes) {
        this.templateTypes = templateTypes;
    }

    protected abstract boolean validateModel(M var1);

    public Class<? extends Transformer<M, M>>[] getTransformerTypes() {
        return this.transformerTypes;
    }

    public Class<? extends Template<M>>[] getTemplateTypes() {
        return this.templateTypes;
    }

    public void setTransformerTypes(Class<? extends Transformer<M, M>> ... transformerTypes) {
        this.transformerTypes = transformerTypes;
    }

    public void setTemplateTypes(Class<? extends Template<M>> ... templateTypes) {
        this.templateTypes = templateTypes;
    }

    @Override
    public void applyTemplate(M model, File destDir) throws IOException {
        boolean isValid = this.validateModel(model);
        if (!isValid) {
            return;
        }
        List<Transformer<M, M>> transformers = this.getInstances(this.getTransformerTypes());
        M currentModel = this.applyTransformers(model, transformers);
        List<Template<M>> templates = this.getInstances(this.getTemplateTypes());
        this.applyTemplates(currentModel, templates, destDir);
    }

    protected M applyTransformers(M model, List<? extends Transformer<M, M>> transformers) {
        M currentModel = model;
        for (Transformer<M, M> template : transformers) {
            if (log.isDebugEnabled()) {
                log.debug("call transformer : " + template.getClass().getSimpleName());
            }
            template.transform(currentModel);
            currentModel = template.getOutputModel();
        }
        return currentModel;
    }

    protected void applyTemplates(M model, List<? extends Template<M>> templates, File destDir) throws IOException {
        for (Template<M> template : templates) {
            if (log.isDebugEnabled()) {
                log.debug("call template : " + template.getClass().getSimpleName());
            }
            template.applyTemplate(model, destDir);
        }
    }

    protected <T extends Template<M>> List<T> getInstances(Class<? extends T>[] types) {
        ArrayList<Template> result = new ArrayList<Template>();
        if (types != null) {
            for (Class<T> clazz : types) {
                if (this.getExcludeTemplates().contains(clazz.getName())) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("exclude generator " + clazz);
                    continue;
                }
                try {
                    Template generator = (Template)clazz.newInstance();
                    generator.setConfiguration(this.getConfiguration());
                    if (generator instanceof AbstractGenerator) {
                        ((AbstractGenerator)generator).setParent(this);
                    }
                    result.add(generator);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("Could not instanciate template " + clazz, (Throwable)e);
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    @Deprecated
    protected List<Template<M>> getTemplates() {
        ArrayList<Template<M>> result = new ArrayList<Template<M>>();
        for (Class<Template<M>> clazz : this.templateTypes) {
            if (this.getExcludeTemplates().contains(clazz.getName())) {
                if (!log.isInfoEnabled()) continue;
                log.info("exclude generator " + clazz);
                continue;
            }
            try {
                Template<M> generator = clazz.newInstance();
                generator.setConfiguration(this.getConfiguration());
                if (generator instanceof AbstractGenerator) {
                    ((AbstractGenerator)generator).setParent(this);
                }
                result.add(generator);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("An error occurs when generating persistence", (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Deprecated
    public Class<? extends Template<M>>[] getTransformers() {
        return this.templateTypes;
    }
}

