/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.MonitorWriter;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.writer.WriterReport;

public abstract class AbstractGenerator<M extends Model>
extends Template<M> {
    private static final Logger log = LogManager.getLogger(AbstractGenerator.class);
    protected AbstractGenerator<M> parent;

    public AbstractGenerator() {
    }

    public AbstractGenerator(AbstractGenerator<M> parent) {
        this.setParent(parent);
    }

    public void setParent(AbstractGenerator<M> parent) {
        this.parent = parent;
    }

    @Override
    public boolean isOverwrite() {
        if (this.parent != null) {
            return this.parent.isOverwrite();
        }
        return super.isOverwrite();
    }

    @Override
    public String getEncoding() {
        if (this.parent != null) {
            return this.parent.getEncoding();
        }
        return super.getEncoding();
    }

    @Override
    public String getProperty(String name) {
        if (this.parent != null) {
            return this.parent.getProperty(name);
        }
        return super.getProperty(name);
    }

    @Override
    public long getLastModifiedSource() {
        if (this.parent != null) {
            return this.parent.getLastModifiedSource();
        }
        return super.getLastModifiedSource();
    }

    @Override
    public <V> V getProperty(String key, Class<V> type) {
        if (this.parent != null) {
            return this.parent.getConfiguration().getProperty(key, type);
        }
        return this.getConfiguration().getProperty(key, type);
    }

    protected boolean isNewerThanSource(File file) {
        if (log.isDebugEnabled()) {
            log.debug("source date: " + this.getLastModifiedSource() + " file date: " + file.lastModified() + " (" + file + ")");
        }
        return file.lastModified() > this.getLastModifiedSource();
    }

    protected File getDestinationFile(File destDir, String filename) {
        return new File(destDir, filename);
    }

    protected boolean canGeneratePackage(String packageName) {
        boolean canGenerate = true;
        if (this.parent != null) {
            return this.parent.canGeneratePackage(packageName);
        }
        List<String> generatedPackages = this.getGeneratedPackages();
        if (generatedPackages != null && !generatedPackages.isEmpty()) {
            canGenerate = false;
            for (String generatedPackage : generatedPackages) {
                Object localGeneratedPackage;
                if (packageName != null && packageName.equals(generatedPackage)) {
                    canGenerate = true;
                }
                if (!((String)(localGeneratedPackage = generatedPackage)).endsWith(".")) {
                    localGeneratedPackage = (String)localGeneratedPackage + ".";
                }
                if (packageName == null || !packageName.startsWith((String)localGeneratedPackage)) continue;
                canGenerate = true;
            }
        }
        return canGenerate;
    }

    protected void write(File outputFile, MonitorWriter out) {
        if (!out.isModified()) {
            if (log.isDebugEnabled()) {
                log.debug("skip generation of " + outputFile + ", No content.");
            }
            return;
        }
        try {
            boolean b;
            outputFile = outputFile.getCanonicalFile();
            if (!outputFile.getParentFile().exists() && !(b = outputFile.getParentFile().mkdirs())) {
                throw new IllegalStateException("could not create directory " + outputFile.getParentFile());
            }
            WriterReport writerReport = this.getWriterReport();
            if (writerReport != null) {
                writerReport.addFile(this.getClass().getName(), outputFile, false);
            }
            try (Writer output = this.getWriter(outputFile);){
                if (log.isDebugEnabled()) {
                    log.debug("Will generate file " + outputFile);
                }
                output.write(out.getBuffer().toString());
            }
        }
        catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to write file : " + outputFile.getAbsolutePath(), (Throwable)eee);
            }
            throw new RuntimeException(eee);
        }
    }

    protected Writer getWriter(File outputFile) throws IOException {
        OutputStreamWriter output;
        FileOutputStream stream = new FileOutputStream(outputFile);
        String encoding = this.getEncoding();
        if (encoding != null) {
            if (log.isDebugEnabled()) {
                log.debug("Force encoding to " + encoding + " : " + this);
            }
            output = new OutputStreamWriter((OutputStream)stream, encoding);
        } else {
            output = new OutputStreamWriter(stream);
        }
        return output;
    }
}

