/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.writer;

import io.ultreia.java4all.lang.ClassLoaders;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterData;
import org.nuiton.eugene.writer.FileGrabber;

public class FileGrabberFromClassPath
implements FileGrabber {
    private static final Logger log = LogManager.getLogger(FileGrabberFromClassPath.class);
    private final ChainedFileWriterConfiguration configuration;

    public FileGrabberFromClassPath(ChainedFileWriterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void addFilesToTreate(File extractDirectory, String inputDirectory, Set<String> includePatterns, ChainedFileWriterData result) throws IOException {
        Map<File, List<File>> filesByRoot = result.getFilesByRoot();
        Map<File, List<File>> resourcesByFile = result.getResourcesByFile();
        String inputPath = inputDirectory;
        File realInputDirectory = inputPath.equals("/") ? extractDirectory : new File(extractDirectory, inputPath.substring(1));
        List<URL> newUrls = this.getFiles(inputDirectory, includePatterns);
        List<File> files = filesByRoot.get(realInputDirectory);
        if (files == null) {
            files = new ArrayList<File>();
            filesByRoot.put(realInputDirectory, files);
        }
        for (URL url : newUrls) {
            File file = this.extractFileFromClassPath(extractDirectory, url);
            files.add(file);
            URL resourceFileUrl = this.getAssociatedResource(url);
            if (resourceFileUrl == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("[" + file + "] No resource associated.");
                continue;
            }
            File resourceFile = this.extractFileFromClassPath(extractDirectory, resourceFileUrl);
            if (log.isDebugEnabled()) {
                log.debug("[" + file + "] Detected resource " + resourceFile);
            }
            resourcesByFile.put(file, Collections.singletonList(resourceFile));
        }
        if (CollectionUtils.isNotEmpty(files)) {
            boolean b;
            boolean bl = b = extractDirectory.exists() || extractDirectory.mkdirs();
            if (!b) {
                throw new IOException("Could not create directory " + extractDirectory);
            }
        }
    }

    protected List<URL> getFiles(String inputPath, Set<String> includePattern) {
        if (CollectionUtils.isEmpty(includePattern)) {
            throw new IllegalArgumentException("Must have at least one include pattern");
        }
        ArrayList<URL> result = new ArrayList<URL>();
        ClassLoader loader = this.configuration.getClassLoader();
        for (String pattern : includePattern) {
            Object path = inputPath;
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            if (((String)(path = (String)path + pattern)).startsWith("/")) {
                path = ((String)path).substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Try to seek class-path file " + (String)path);
            }
            if (pattern.contains("*")) {
                List urlList = ClassLoaders.getURLs((String)path, (URLClassLoader)((URLClassLoader)loader));
                if (CollectionUtils.isEmpty((Collection)urlList)) {
                    log.warn("Could not find in class-path files " + (String)path);
                    continue;
                }
                for (URL url : urlList) {
                    if (this.configuration.isVerbose()) {
                        log.info("Detected class-path file " + url);
                    }
                    result.add(url);
                }
                continue;
            }
            URL url = loader.getResource((String)path);
            if (url == null) {
                log.warn("Could not find in class-path the file " + (String)path);
                continue;
            }
            if (this.configuration.isVerbose()) {
                log.info("Detected class-path file " + url);
            }
            result.add(url);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getAssociatedResource(URL file) throws IOException {
        URL result;
        String path = file.toString();
        String extension = "." + FileUtils.extension((String)path);
        String filename = StringUtils.substring((String)path, (int)0, (int)(-extension.length())).concat(".properties");
        if (log.isDebugEnabled()) {
            log.info("path of file : " + path);
            log.info("path of resource : " + filename);
        }
        URL propertiesFile = URI.create(filename).toURL();
        if (path.startsWith("file:")) {
            File file1 = new File(propertiesFile.getFile());
            result = file1.exists() ? propertiesFile : null;
        } else {
            try (InputStream in = null;){
                in = propertiesFile.openStream();
                result = propertiesFile;
            }
        }
        return result;
    }

    protected File extractFileFromClassPath(File extractDirectory, URL url) throws IOException {
        File parentFile;
        boolean b;
        String path = url.getPath();
        int index = path.indexOf("!");
        if (index == -1) {
            index = path.lastIndexOf("/") - 1;
        }
        String relativePath = path.substring(index + 1);
        File f = new File(extractDirectory, relativePath);
        if (log.isDebugEnabled()) {
            log.debug("extract " + url + " to " + f);
        }
        boolean bl = b = (parentFile = f.getParentFile()).exists() || parentFile.mkdirs();
        if (!b) {
            throw new IOException("Could not create directory " + f);
        }
        try (FileOutputStream out = new FileOutputStream(f);){
            IOUtils.copy((InputStream)url.openStream(), (OutputStream)out);
        }
        return f;
    }
}

