/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.writer.ChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterData;
import org.nuiton.eugene.writer.ChainedFileWriterEntry;
import org.nuiton.eugene.writer.WriterReport;

public abstract class AbstractChainedFileWriter
implements ChainedFileWriter {
    private static final Logger log = LogManager.getLogger(AbstractChainedFileWriter.class);
    protected List<ChainedFileWriterEntry> entries;
    protected ChainedFileWriter previousWriter;
    protected ChainedFileWriter nextWriter;
    protected final Map<String, String> authorizedPropertyDescriptions;
    protected Map<String, Object> properties;
    private WriterReport writerReport;

    protected abstract void generate(ChainedFileWriterConfiguration var1, File var2, Map<File, List<File>> var3, Map<File, List<File>> var4) throws IOException;

    protected AbstractChainedFileWriter(String ... propertyNameAndDescriptions) {
        if (propertyNameAndDescriptions.length % 2 != 0) {
            throw new IllegalArgumentException("propertyNameAndDescriptions must be couple of (property key, property description), but was " + Arrays.toString(propertyNameAndDescriptions));
        }
        this.entries = new ArrayList<ChainedFileWriterEntry>();
        this.properties = new TreeMap<String, Object>();
        TreeMap<String, String> authorizedPropertyDescriptions = new TreeMap<String, String>();
        int max = propertyNameAndDescriptions.length / 2;
        for (int i = 0; i < max; ++i) {
            authorizedPropertyDescriptions.put(propertyNameAndDescriptions[2 * i], propertyNameAndDescriptions[2 * i + 1]);
        }
        this.authorizedPropertyDescriptions = Collections.unmodifiableMap(authorizedPropertyDescriptions);
    }

    @Override
    public Map<String, String> getAuthorizedPropertyDescriptions() {
        return this.authorizedPropertyDescriptions;
    }

    @Override
    public String[] getAuthorizedPropertyNames() {
        Set<String> keys = this.authorizedPropertyDescriptions.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public void clear() {
        this.entries.clear();
        this.properties.clear();
        this.nextWriter = null;
        this.previousWriter = null;
    }

    @Override
    public void addEntry(ChainedFileWriterEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(ChainedFileWriterConfiguration configuration, ChainedFileWriterData data) throws IOException {
        this.initWriter(configuration);
        try {
            File outputDir = data.getOutputDirectory();
            Map<File, List<File>> filesByRoot = data.getFilesByRoot();
            Map<File, List<File>> resourcesByFile = data.getResourcesByFile();
            this.generate(configuration, outputDir, filesByRoot, resourcesByFile);
        }
        finally {
            this.clear();
        }
    }

    @Override
    public String getInputProtocol(String modelType) {
        return this.acceptModel(modelType) ? this.getInputProtocol() : null;
    }

    @Override
    public File getOutputDirectory(File outputBasedir, boolean testPhase) {
        return new File(outputBasedir, testPhase ? this.getDefaultTestOutputDirectory() : this.getDefaultOutputDirectory());
    }

    @Override
    public File getExtractDirectory(File outputBasedir, boolean testPhase) {
        return new File(outputBasedir, (String)(testPhase ? "test-" + this.getInputProtocol() : this.getInputProtocol()));
    }

    @Override
    public List<ChainedFileWriterEntry> getEntries() {
        return this.entries;
    }

    @Override
    public WriterReport getWriterReport() {
        return this.writerReport;
    }

    @Override
    public void setWriterReport(WriterReport writerReport) {
        this.writerReport = writerReport;
    }

    protected ChainedFileWriter getNextWriter() {
        return this.nextWriter;
    }

    protected ChainedFileWriter getPreviousWriter() {
        return this.previousWriter;
    }

    protected void setNextWriter(ChainedFileWriter nextWriter) {
        this.nextWriter = nextWriter;
    }

    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        Map<String, Object> map = configuration.getProperties();
        boolean verbose = configuration.isVerbose();
        for (String key : this.getAuthorizedPropertyNames()) {
            if (!map.containsKey(key)) continue;
            Object value = map.get(key);
            if (verbose) {
                log.info("[" + this.getClass().getName() + "] add configuration property " + key + " = " + value);
            }
            this.properties.put(key, value);
        }
    }
}

