/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.tagvalue;

import java.util.Map;
import org.nuiton.eugene.models.tagvalue.TagValuesStore;

public final class TagValueQueryBuilder {
    private final TagValuesStore store;

    public static TagValueQueryBuilder create(TagValuesStore store) {
        return new TagValueQueryBuilder(store);
    }

    public TagValueQueryBuilder(TagValuesStore store) {
        this.store = store;
    }

    public OnModel onModel(String modelName) {
        return new Builder().onModel(modelName);
    }

    public OnPackage onPackage(String packageName) {
        return new Builder().onPackage(packageName);
    }

    public OnClassifier onClassifier(String classifierName) {
        return new Builder().onClassifier(classifierName);
    }

    private class Builder
    implements StepWith,
    OnModel,
    OnPackage,
    OnClassifier,
    OnAttribute,
    OnTagValue,
    StepResult {
        private String key;

        private Builder() {
        }

        @Override
        public String single() {
            return TagValueQueryBuilder.this.store.getStore().getProperty(this.key);
        }

        @Override
        public Map<String, String> multiple() {
            return TagValueQueryBuilder.this.store.getTagValues(this.key);
        }

        @Override
        public StepResult onTagValue(String tagValue) {
            this.key = this.key + ".tagValue." + tagValue;
            return this;
        }

        @Override
        public OnModel onModel(String modelName) {
            this.key = "model." + modelName;
            return this;
        }

        @Override
        public OnPackage onPackage(String packageName) {
            this.key = "package." + packageName;
            return this;
        }

        @Override
        public OnClassifier onClassifier(String classifierName) {
            this.key = classifierName + ".class";
            return this;
        }

        @Override
        public OnAttribute onAttribute(String attributeName) {
            this.key = this.key.replace(".class", "");
            this.key = this.key + ".attribute." + attributeName;
            return this;
        }
    }

    public static interface OnAttribute
    extends OnTagValue,
    StepMultipleResult {
    }

    public static interface OnClassifier
    extends OnTagValue,
    StepMultipleResult {
        public OnAttribute onAttribute(String var1);
    }

    public static interface OnPackage
    extends OnTagValue,
    StepMultipleResult {
    }

    public static interface OnModel
    extends OnTagValue,
    StepMultipleResult {
    }

    public static interface StepWith {
        public OnModel onModel(String var1);

        public OnPackage onPackage(String var1);

        public OnClassifier onClassifier(String var1);
    }

    public static interface StepMultipleResult {
        public Map<String, String> multiple();
    }

    public static interface StepResult {
        public String single();
    }

    public static interface OnTagValue {
        public StepResult onTagValue(String var1);
    }
}

