/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.tagvalue;

import java.util.Iterator;
import java.util.Objects;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.tagvalue.TagValueQueryBuilder;
import org.nuiton.eugene.models.tagvalue.TagValuesStore;

public class ObjectModelTagValuesStore {
    private final TagValuesStore store;
    private final ObjectModel model;
    private final TagValueQueryBuilder queryBuilder;

    public ObjectModelTagValuesStore(ObjectModel model) {
        this.model = Objects.requireNonNull(model);
        this.store = new TagValuesStore();
        this.queryBuilder = new TagValueQueryBuilder(this.store);
    }

    public String findClassifierTagValue(TagValueMetadata tagName, ObjectModelClass clazz) {
        String result;
        block1: {
            ObjectModelClass superclass;
            result = this.onClassifier(clazz.getQualifiedName()).onTagValue(tagName.getName()).single();
            if (result != null) break block1;
            Iterator<ObjectModelClass> iterator = clazz.getSuperclasses().iterator();
            while (iterator.hasNext() && (result = this.onClassifier((superclass = iterator.next()).getQualifiedName()).onTagValue(tagName.getName()).single()) == null) {
            }
        }
        return result;
    }

    public String findAttributeTagValue(TagValueMetadata tagName, ObjectModelClass clazz, ObjectModelAttribute attribute) {
        String result;
        block1: {
            ObjectModelClass superclass;
            result = this.onClassifier(clazz.getQualifiedName()).onAttribute(attribute.getName()).onTagValue(tagName.getName()).single();
            if (result != null) break block1;
            Iterator<ObjectModelClass> iterator = clazz.getSuperclasses().iterator();
            while (iterator.hasNext() && (result = this.onClassifier((superclass = iterator.next()).getQualifiedName()).onAttribute(attribute.getName()).onTagValue(tagName.getName()).single()) == null) {
            }
        }
        return result;
    }

    public boolean findClassifierBooleanTagValue(TagValueMetadata tagName, ObjectModelClass clazz) {
        String result = this.findClassifierTagValue(tagName, clazz);
        return TagValueUtil.findBooleanTagValue(result);
    }

    public Integer findClassifierIntegerTagValue(TagValueMetadata tagName, ObjectModelClass clazz) {
        String result = this.findClassifierTagValue(tagName, clazz);
        return TagValueUtil.findIntegerTagValue(result);
    }

    public boolean findAttributeBooleanTagValue(TagValueMetadata tagName, ObjectModelClass clazz, ObjectModelAttribute attribute) {
        String result = this.findAttributeTagValue(tagName, clazz, attribute);
        return TagValueUtil.findBooleanTagValue(result);
    }

    public Integer findAttributeIntegerTagValue(TagValueMetadata tagName, ObjectModelClass clazz, ObjectModelAttribute attribute) {
        String result = this.findAttributeTagValue(tagName, clazz, attribute);
        return TagValueUtil.findIntegerTagValue(result);
    }

    public TagValueQueryBuilder.OnModel onModel(String modelName) {
        return this.queryBuilder.onModel(modelName);
    }

    public TagValueQueryBuilder.OnPackage onPackage(String packageName) {
        return this.queryBuilder.onPackage(packageName);
    }

    public TagValueQueryBuilder.OnClassifier onClassifier(String classifierName) {
        return this.queryBuilder.onClassifier(classifierName);
    }

    public TagValuesStore getStore() {
        return this.store;
    }

    public String getModelTagValue(String name) {
        return this.store.getModelTagValue(this.model.getName(), name);
    }

    public String getPackageTagValue(String packageName, String name) {
        return this.store.getPackageTagValue(packageName, name);
    }

    public String getClassifierTagValue(String classifierName, String name) {
        return this.store.getClassifierTagValue(classifierName, name);
    }

    public String getAttributeTagValue(String classifierName, String attributeName, String name) {
        return this.store.getAttributeTagValue(classifierName, attributeName, name);
    }
}

