/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.state.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.eugene.models.state.StateModelStateChart;
import org.nuiton.eugene.models.state.xml.StateModelStateChartImpl;

@Component(role=Model.class, hint="statemodel")
public class StateModelImpl
implements StateModel {
    protected List<StateModelStateChart> listStateCharts;
    protected String name;
    protected String version;
    protected Map<String, String> modelTagValues;
    private Map<String, Object> extensions = new HashMap<String, Object>();

    public StateModelImpl() {
        this.listStateCharts = new ArrayList<StateModelStateChart>();
        this.modelTagValues = new HashMap<String, String>();
    }

    @Override
    public String getModelType() {
        return ModelHelper.ModelType.STATE.getAlias();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getStereotypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : this.modelTagValues.entrySet()) {
            if (!"true".equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public boolean hasStereotype(String stereotypeName) {
        return this.modelTagValues.containsKey(stereotypeName);
    }

    @Override
    public void addStereotype(String stereotype) {
        this.modelTagValues.put(stereotype, "true");
    }

    @Override
    public void removeStereotype(String stereotype) {
        this.modelTagValues.remove(stereotype);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addStateChart(StateModelStateChart chart) {
        ((StateModelStateChartImpl)chart).correctTransitionNameToInstance(null);
        this.listStateCharts.add(chart);
    }

    @Override
    public List<StateModelStateChart> getStateCharts() {
        return this.listStateCharts;
    }

    public void addAllStateCharts(Collection<StateModelStateChart> charts) {
        this.listStateCharts.addAll(charts);
    }

    @Override
    public Map<String, String> getTagValues() {
        return this.modelTagValues;
    }

    @Override
    public void addTagValue(String key, String value) {
        this.modelTagValues.put(key, value);
    }

    @Override
    public String getTagValue(String key) {
        return key == null ? null : this.modelTagValues.get(key);
    }

    @Override
    public boolean hasTagValue(String tagValue) {
        return this.modelTagValues.containsKey(tagValue);
    }

    @Override
    public void removeTagValue(String tagvalue) {
        this.modelTagValues.remove(tagvalue);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public <O> O getExtension(String reference, Class<O> extensionClass) throws RuntimeException {
        Object result;
        if (reference == null) {
            throw new NullPointerException("reference parameter can not be null in method ObjectModelImpl#getExtension");
        }
        if (extensionClass == null) {
            throw new NullPointerException("extensionClass parameter can not be null in method ObjectModelImpl#getExtension.");
        }
        Object object = this.extensions.get(reference);
        if (object != null && !extensionClass.isAssignableFrom(object.getClass())) {
            throw new ClassCastException("Invalid cast for " + extensionClass.getName());
        }
        if (object == null) {
            try {
                result = extensionClass.newInstance();
            }
            catch (Exception eee) {
                throw new RuntimeException("Unable to create new extension '" + extensionClass.getName() + "' for '" + reference + "'", eee);
            }
            this.extensions.put(reference, result);
        } else {
            result = object;
        }
        return (O)result;
    }
}

