/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.state;

import io.ultreia.java4all.util.RecursiveProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.RuleSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.eugene.models.state.xml.DigesterStateModelRuleSet;
import org.nuiton.eugene.models.state.xml.StateModelImpl;
import org.xml.sax.SAXException;

@Component(role=ModelReader.class, hint="statemodel")
public class StateModelReader
extends ModelReader<StateModel> {
    private static final Logger log = LogManager.getLogger(StateModelReader.class);

    @Override
    public String getModelType() {
        return ModelHelper.ModelType.STATE.getAlias();
    }

    @Override
    public String getInputType() {
        return ModelHelper.ModelInputType.XML.getAlias();
    }

    @Override
    public StateModel read(File ... files) {
        Digester digester = new Digester();
        digester.addRuleSet((RuleSet)new DigesterStateModelRuleSet());
        StateModelImpl stateModel = new StateModelImpl();
        for (File file : files) {
            try {
                digester.push((Object)stateModel);
                digester.parse(file);
                this.loadPropertyFile(file, stateModel);
            }
            catch (IOException | SAXException e) {
                log.warn("Can't read model file", (Throwable)e);
            }
        }
        return stateModel;
    }

    protected void loadPropertyFile(File stateModelFile, StateModelImpl stateModel) {
        File dir = stateModelFile.getParentFile();
        String ext = FileUtils.extension((String)stateModelFile.getName());
        String name = FileUtils.basename((String)stateModelFile.getName(), (String)("." + ext));
        File propFile = new File(dir, name + ".properties");
        RecursiveProperties prop = new RecursiveProperties();
        if (!propFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info("No property file associated to model : " + propFile);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Reading model property file " + propFile);
            }
            try (FileInputStream inStream = new FileInputStream(propFile);){
                prop.load((InputStream)inStream);
            }
            catch (IOException e) {
                log.warn("Cannot read or close property file " + propFile, (Throwable)e);
            }
            for (Object o : prop.keySet()) {
                String key = (String)o;
                String value = prop.getProperty(key);
                if (!key.startsWith("model.tagvalue.")) {
                    log.warn("only tagvalue is allowed on model in properties");
                    continue;
                }
                String tag = key.substring("model.tagvalue.".length());
                stateModel.addTagValue(tag, value);
            }
        }
    }
}

