/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.state;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.MonitorWriter;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.eugene.models.state.StateModelState;
import org.nuiton.eugene.models.state.StateModelStateChart;

public class StateModelGenerator
extends AbstractGenerator<StateModel> {
    private static Logger log = LogManager.getLogger(StateModelGenerator.class);

    public StateModelGenerator() {
    }

    public StateModelGenerator(AbstractGenerator<StateModel> parent) {
        super(parent);
    }

    @Override
    public void applyTemplate(StateModel stateModel, File destDir) throws IOException {
        this.model = stateModel;
        String filename = this.getFilenameFromModel(stateModel);
        File outputFile = this.getDestinationFile(destDir, filename);
        if (this.isOverwrite() || !this.isNewerThanSource(outputFile)) {
            try (MonitorWriter monitorOut = new MonitorWriter(new StringWriter());){
                this.generateFromModel(monitorOut, stateModel);
                this.write(outputFile, monitorOut);
            }
            catch (Exception eee) {
                log.warn("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile);
                throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile, eee);
            }
        }
        for (StateModelStateChart chart : stateModel.getStateCharts()) {
            if (!this.canGenerateElement(chart)) continue;
            for (Object oState : chart.getStates().toArray()) {
                StateModelState state = (StateModelState)oState;
                String filenameState = this.getFilenameFromState(state, chart.getName());
                File outputFiletate = this.getDestinationFile(destDir, filenameState);
                if (!this.isOverwrite() && this.isNewerThanSource(outputFiletate)) continue;
                try (MonitorWriter monitorOut = new MonitorWriter(new StringWriter());){
                    this.generateFromState(monitorOut, state);
                    this.write(outputFiletate, monitorOut);
                }
                catch (Exception eee) {
                    log.warn("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFiletate);
                    throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFiletate, eee);
                }
            }
        }
    }

    protected boolean canGenerateElement(StateModelStateChart chart) {
        boolean canGenerate = true;
        return canGenerate;
    }

    protected void generateFromModel(MonitorWriter monitorOut, StateModel stateModel) {
    }

    protected String getFilenameFromModel(StateModel stateModel) {
        return stateModel.getName();
    }

    public String getFilenameFromState(StateModelState state, String packageName) {
        return (packageName + "." + state.getName()).replace('.', File.separatorChar);
    }

    public void generateFromState(Writer monitorOut, StateModelState state) throws IOException {
    }
}

