/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplTagValue;

public class ObjectModelPackageImpl
implements ObjectModelPackage {
    private static final Logger log = LogManager.getLogger(ObjectModelPackageImpl.class);
    protected ObjectModelImpl objectModelImpl;
    protected boolean extern;
    protected String name;
    protected int numberOfSubPackages;
    protected ObjectModelPackage parentPackage;
    protected String documentation;
    protected Set<String> stereotypes = new HashSet<String>();
    protected Map<String, String> tagValues = new HashMap<String, String>();
    protected List<String> comments = new ArrayList<String>();
    protected final Predicate<ObjectModelClassifier> IS_PACKAGE_NAME_EQUALS_PREDICATE = new PackageNameEqualsPredicate(this.name);
    protected final Predicate<ObjectModelPackage> IS_PACKAGE_NAME_STARTS_WITH_PREDICATE = new PackageNameStartsWithPredicate(this.name + ".");

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfSubPackages() {
        return this.numberOfSubPackages;
    }

    @Override
    public ObjectModelPackage getParentPackage() {
        return this.parentPackage;
    }

    @Override
    public String getDescription() {
        return this.getDocumentation().substring(0, this.getDocumentation().indexOf("--"));
    }

    @Override
    public String getSourceDocumentation() {
        return this.getDocumentation().substring(this.getDocumentation().indexOf("--") + 2);
    }

    @Override
    public Set<String> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public boolean hasStereotype(String stereotypeName) {
        return this.stereotypes.contains(stereotypeName);
    }

    @Override
    public void addStereotype(String stereotype) {
        this.stereotypes.add(stereotype);
    }

    @Override
    public void removeStereotype(String stereotype) {
        this.stereotypes.remove(stereotype);
    }

    @Override
    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    @Override
    public String getTagValue(String tagValue) {
        return tagValue == null ? null : this.tagValues.get(tagValue);
    }

    @Override
    public boolean hasTagValue(String tagValue) {
        return this.tagValues.containsKey(tagValue);
    }

    @Override
    public void addTagValue(String tagValue, String value) {
        String oldValue = this.getTagValue(tagValue);
        if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
            if (oldValue.equals(value)) {
                return;
            }
            log.warn("Replace tagValue '" + tagValue + "' (old:" + oldValue + ", new: " + value + ")");
        }
        this.tagValues.put(tagValue, value);
    }

    @Override
    public void removeTagValue(String tagvalue) {
        this.tagValues.remove(tagvalue);
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public Iterable<ObjectModelPackage> getPackages() {
        return Iterables.filter(this.objectModelImpl.getPackages(), this.IS_PACKAGE_NAME_STARTS_WITH_PREDICATE);
    }

    @Override
    public boolean hasPackage(String packageName) {
        ObjectModelPackage aPackage = this.objectModelImpl.getPackage(packageName);
        return aPackage != null && this.IS_PACKAGE_NAME_STARTS_WITH_PREDICATE.apply((Object)aPackage);
    }

    @Override
    public Iterable<ObjectModelClassifier> getClassifiers() {
        return Iterables.filter(this.objectModelImpl.getClassifiers(), this.IS_PACKAGE_NAME_EQUALS_PREDICATE);
    }

    @Override
    public ObjectModelClassifier getClassifier(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = Iterables.filter(this.objectModelImpl.getClassifiers(), predicate);
        return (ObjectModelClassifier)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public Iterable<ObjectModelClass> getClasses() {
        return Iterables.filter(this.objectModelImpl.getClasses(), this.IS_PACKAGE_NAME_EQUALS_PREDICATE);
    }

    @Override
    public ObjectModelClass getClass(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = Iterables.filter(this.objectModelImpl.getClasses(), predicate);
        return (ObjectModelClass)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public boolean hasClass(String simpleName) {
        return false;
    }

    @Override
    public Iterable<ObjectModelInterface> getInterfaces() {
        return Iterables.filter(this.objectModelImpl.getInterfaces(), this.IS_PACKAGE_NAME_EQUALS_PREDICATE);
    }

    @Override
    public ObjectModelInterface getInterface(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = Iterables.filter(this.objectModelImpl.getInterfaces(), predicate);
        return (ObjectModelInterface)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public Iterable<ObjectModelEnumeration> getEnumerations() {
        return Iterables.filter(this.objectModelImpl.getEnumerations(), this.IS_PACKAGE_NAME_EQUALS_PREDICATE);
    }

    @Override
    public ObjectModelEnumeration getEnumeration(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = Iterables.filter(this.objectModelImpl.getEnumerations(), predicate);
        return (ObjectModelEnumeration)Iterables.getFirst((Iterable)filter, null);
    }

    public boolean isExtern() {
        return this.extern;
    }

    public void setExtern(boolean extern) {
        this.extern = extern;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public ObjectModelImplRef addStereotype(ObjectModelImplRef stereotype) {
        if (stereotype == null) {
            return new ObjectModelImplRef();
        }
        this.stereotypes.add(stereotype.getName());
        return stereotype;
    }

    public ObjectModelImplTagValue addTagValue(ObjectModelImplTagValue tagValue) {
        if (tagValue == null) {
            return new ObjectModelImplTagValue();
        }
        this.addTagValue(tagValue.getName(), tagValue.getValue());
        return tagValue;
    }

    public void setObjectModelImpl(ObjectModelImpl objectModelImpl) {
        this.objectModelImpl = objectModelImpl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPackage(ObjectModelPackage parentPackage) {
        this.parentPackage = parentPackage;
    }

    public void postInit() {
        this.numberOfSubPackages = this.name.split("\\.").length;
    }

    protected Predicate<ObjectModelClassifier> newClassifierNameEquals(String simpleName) {
        Predicate predicate = Predicates.and(this.IS_PACKAGE_NAME_EQUALS_PREDICATE, (Predicate)new SimpleNameEqualsPredicate(simpleName));
        return predicate;
    }

    protected static class PackageNameStartsWithPredicate
    implements Predicate<ObjectModelPackage> {
        protected final String name;

        public PackageNameStartsWithPredicate(String name) {
            this.name = name;
        }

        public boolean apply(ObjectModelPackage input) {
            return input.getName().startsWith(this.name);
        }
    }

    protected static class PackageNameEqualsPredicate
    implements Predicate<ObjectModelClassifier> {
        protected final String name;

        public PackageNameEqualsPredicate(String name) {
            this.name = name;
        }

        public boolean apply(ObjectModelClassifier input) {
            return input.getPackageName().equals(this.name);
        }
    }

    protected static class SimpleNameEqualsPredicate
    implements Predicate<ObjectModelClassifier> {
        protected final String name;

        public SimpleNameEqualsPredicate(String name) {
            this.name = name;
        }

        public boolean apply(ObjectModelClassifier input) {
            return input.getName().equals(this.name);
        }
    }
}

