/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class ObjectModelOperationImpl
extends ObjectModelElementImpl
implements ObjectModelOperation {
    public static final ObjectModelJavaModifier DEFAULT_VISIBILITY = ObjectModelJavaModifier.PUBLIC;
    protected ObjectModelParameter returnParameter;
    protected String transactionLevel = "supports";
    protected List<ObjectModelParameter> parameters = new ArrayList<ObjectModelParameter>();
    protected Set<String> exceptions = new HashSet<String>();
    protected String bodyCode = "";
    private static Set<ObjectModelModifier> authorizedModifiers;

    @Override
    protected Set<ObjectModelModifier> getAuthorizedModifiers() {
        if (authorizedModifiers == null) {
            HashSet modifiers = Sets.newHashSet((Object[])new ObjectModelModifier[]{ObjectModelJavaModifier.ABSTRACT, ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.SYNCHRONIZED, ObjectModelJavaModifier.DEFAULT, ObjectModelJavaModifier.NATIVE, ObjectModelJavaModifier.STRICTFP});
            modifiers.addAll(ObjectModelJavaModifier.visibilityModifiers);
            authorizedModifiers = ImmutableSet.copyOf((Collection)modifiers);
        }
        return authorizedModifiers;
    }

    public String toString() {
        return this.getName() + "(" + this.parameters + ")<<" + this.getStereotypes() + ">> throws " + this.exceptions + " tagvalue: " + this.getTagValues();
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectModelOperation) {
            ObjectModelOperation op = (ObjectModelOperation)o;
            if (this.getName().equals(op.getName()) && this.getParameters().size() == op.getParameters().size()) {
                Iterator<ObjectModelParameter> i = this.getParameters().iterator();
                Iterator<ObjectModelParameter> opi = op.getParameters().iterator();
                while (i.hasNext() && opi.hasNext()) {
                    ObjectModelParameter p = i.next();
                    ObjectModelParameter pop = opi.next();
                    if (p.getType().equals(pop.getType())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void addParameter(ObjectModelParameterImpl parameter) {
        parameter.postInit();
        parameter.setDeclaringElement(this);
        this.parameters.add(parameter);
    }

    public void setVisibility(String visibility) {
        ObjectModelJavaModifier modifier = ObjectModelJavaModifier.fromVisibility(visibility);
        this.removeModifiers(ObjectModelJavaModifier.visibilityModifiers);
        if (modifier == null) {
            modifier = DEFAULT_VISIBILITY;
        }
        this.addModifier(modifier);
    }

    public void setAbstract(boolean abstractz) {
        this.addOrRemoveModifier(ObjectModelJavaModifier.ABSTRACT, abstractz);
    }

    public void setReturnParameter(ObjectModelParameterImpl returnParameter) {
        returnParameter.postInit();
        returnParameter.setDeclaringElement(this);
        this.returnParameter = returnParameter;
    }

    public void setBodyCode(String bodyCode) {
        this.bodyCode = bodyCode;
    }

    public void addBodyCode(String bodyCode) {
        this.bodyCode = this.bodyCode + bodyCode;
    }

    @Override
    public ObjectModelParameter getReturnParameter() {
        return this.returnParameter;
    }

    @Override
    public String getReturnType() {
        if (this.returnParameter != null) {
            return this.returnParameter.getType();
        }
        return "void";
    }

    @Override
    public String getVisibility() {
        String visibility = DEFAULT_VISIBILITY.toString();
        if (this.modifiers.contains(ObjectModelJavaModifier.PRIVATE)) {
            visibility = ObjectModelJavaModifier.PRIVATE.toString();
        } else if (this.modifiers.contains(ObjectModelJavaModifier.PROTECTED)) {
            visibility = ObjectModelJavaModifier.PROTECTED.toString();
        }
        if (this.modifiers.contains(ObjectModelJavaModifier.PACKAGE)) {
            visibility = ObjectModelJavaModifier.PACKAGE.toString();
        }
        return visibility;
    }

    @Override
    public boolean isAbstract() {
        return this.modifiers.contains(ObjectModelJavaModifier.ABSTRACT);
    }

    @Override
    public boolean isDefault() {
        return this.modifiers.contains(ObjectModelJavaModifier.DEFAULT);
    }

    @Override
    public boolean isFinal() {
        return this.modifiers.contains(ObjectModelJavaModifier.FINAL);
    }

    @Override
    public Collection<ObjectModelParameter> getParameters() {
        return this.parameters;
    }

    public void addExceptionParameter(ObjectModelParameterImpl raisedParameter) {
        raisedParameter.postInit();
        raisedParameter.setDeclaringElement(this);
        this.exceptions.add(raisedParameter.getType());
    }

    @Override
    public Set<String> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getBodyCode() {
        return this.bodyCode;
    }
}

