/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModeImplAssociationClassParticipant;
import org.nuiton.eugene.models.object.xml.ObjectModelAssociationClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelDependencyImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplTagValue;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelPackageImpl;
import org.nuiton.eugene.models.tagvalue.ObjectModelTagValuesStore;

@Component(role=Model.class, hint="objectmodel")
public class ObjectModelImpl
implements ObjectModel {
    private static final Logger log = LogManager.getLogger(ObjectModelImpl.class);
    private final ObjectModelTagValuesStore tagValuesStore;
    protected String name;
    protected String version;
    protected Map<String, ObjectModelClass> classes = new HashMap<String, ObjectModelClass>();
    protected Map<String, ObjectModelPackage> packages = new HashMap<String, ObjectModelPackage>();
    protected Map<String, ObjectModelInterface> interfaces = new HashMap<String, ObjectModelInterface>();
    protected Map<String, ObjectModelClassifier> classifiers = new HashMap<String, ObjectModelClassifier>();
    protected Map<String, ObjectModelEnumeration> enumerations = new HashMap<String, ObjectModelEnumeration>();
    protected List<String> comments = new ArrayList<String>();
    protected Map<String, String> tagValues = new HashMap<String, String>();
    private Map<String, Object> extensions = new HashMap<String, Object>();

    public ObjectModelImpl() {
        this.tagValuesStore = new ObjectModelTagValuesStore(this);
    }

    @Override
    public ObjectModelTagValuesStore getTagValuesStore() {
        return this.tagValuesStore;
    }

    @Override
    public String getModelType() {
        return ModelHelper.ModelType.OBJECT.getAlias();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void addPackage(ObjectModelPackageImpl aPackage) {
        aPackage.postInit();
        aPackage.setObjectModelImpl(this);
        if (!aPackage.isExtern()) {
            ObjectModelPackageImpl initialElement = (ObjectModelPackageImpl)this.packages.get(aPackage.getName());
            if (initialElement == null) {
                this.packages.put(aPackage.getName(), aPackage);
            } else {
                this.mergePackages(initialElement, aPackage);
            }
        }
    }

    public void addClass(ObjectModelClassImpl clazz) {
        clazz.postInit();
        clazz.setObjectModelImpl(this);
        if (!clazz.isExtern()) {
            ObjectModelElementImpl initialElement = (ObjectModelElementImpl)((Object)this.classes.get(clazz.getQualifiedName()));
            if (initialElement == null) {
                this.classes.put(clazz.getQualifiedName(), clazz);
                this.classifiers.put(clazz.getQualifiedName(), clazz);
            } else {
                if (!(initialElement instanceof ObjectModelClassImpl)) {
                    throw new IllegalArgumentException("\"" + clazz + "\" is incompatible with already defined element \"" + initialElement + "\"");
                }
                ObjectModelClassImpl initialClazz = (ObjectModelClassImpl)initialElement;
                this.mergeClasses(initialClazz, clazz);
            }
        }
    }

    public void addAssociationClass(ObjectModelAssociationClassImpl clazz) {
        clazz.postInit();
        clazz.setObjectModelImpl(this);
        if (!clazz.isExtern()) {
            ObjectModelElementImpl initialElement = (ObjectModelElementImpl)((Object)this.classes.get(clazz.getQualifiedName()));
            if (initialElement == null) {
                this.classes.put(clazz.getQualifiedName(), clazz);
                this.classifiers.put(clazz.getQualifiedName(), clazz);
            } else {
                if (!(initialElement instanceof ObjectModelAssociationClassImpl)) {
                    throw new IllegalArgumentException("\"" + clazz + "\" is incompatible with already defined element \"" + initialElement + "\"");
                }
                ObjectModelAssociationClassImpl initialClazz = (ObjectModelAssociationClassImpl)initialElement;
                this.mergeAssociationClasses(initialClazz, clazz);
            }
        }
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<ObjectModelPackage> getPackages() {
        return this.packages.values();
    }

    @Override
    public ObjectModelPackage getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Override
    public ObjectModelPackage getPackage(ObjectModelClassifier classifier) {
        return this.getPackage(classifier.getPackageName());
    }

    @Override
    public boolean hasPackage(String packageName) {
        return this.packages.containsKey(packageName);
    }

    @Override
    public Collection<ObjectModelClassifier> getClassifiers() {
        return this.classifiers.values();
    }

    @Override
    public ObjectModelClassifier getClassifier(String qualifiedClassifierName) {
        return qualifiedClassifierName == null ? null : this.classifiers.get(qualifiedClassifierName);
    }

    @Override
    public Collection<ObjectModelClass> getClasses() {
        return this.classes.values();
    }

    @Override
    public ObjectModelClass getClass(String qualifiedClassName) {
        if (qualifiedClassName == null) {
            return null;
        }
        if (!this.hasClass(qualifiedClassName)) {
            if (log.isDebugEnabled()) {
                log.debug("Class " + qualifiedClassName + " not found in model");
            }
            return null;
        }
        return this.classes.get(qualifiedClassName);
    }

    @Override
    public boolean hasClass(String qualifiedClassName) {
        boolean hasClass = this.classes.containsKey(qualifiedClassName);
        return hasClass;
    }

    public void addInterface(ObjectModelInterfaceImpl interfacez) {
        interfacez.postInit();
        interfacez.setObjectModelImpl(this);
        if (!interfacez.isExtern()) {
            ObjectModelElementImpl initialElement = (ObjectModelElementImpl)((Object)this.interfaces.get(interfacez.getQualifiedName()));
            if (initialElement == null) {
                this.interfaces.put(interfacez.getQualifiedName(), interfacez);
                this.classifiers.put(interfacez.getQualifiedName(), interfacez);
            } else {
                if (!(initialElement instanceof ObjectModelInterfaceImpl)) {
                    throw new IllegalArgumentException("\"" + interfacez + "\" is incompatible with already defined element \"" + initialElement + "\"");
                }
                ObjectModelInterfaceImpl initialInterfacez = (ObjectModelInterfaceImpl)initialElement;
                this.mergeClassifiers(initialInterfacez, interfacez);
            }
        }
    }

    @Override
    public ObjectModelInterface getInterface(String qualifiedInterfaceName) {
        ObjectModelInterface result = this.interfaces.get(qualifiedInterfaceName);
        if (result == null && log.isDebugEnabled()) {
            log.debug("Interface " + qualifiedInterfaceName + " not found in model");
        }
        return result;
    }

    @Override
    public Collection<ObjectModelInterface> getInterfaces() {
        return this.interfaces.values();
    }

    public void addEnumeration(ObjectModelEnumerationImpl enumeration) {
        enumeration.postInit();
        enumeration.setObjectModelImpl(this);
        this.classifiers.put(enumeration.getQualifiedName(), enumeration);
        this.enumerations.put(enumeration.getQualifiedName(), enumeration);
    }

    @Override
    public Collection<ObjectModelEnumeration> getEnumerations() {
        return this.enumerations.values();
    }

    @Override
    public ObjectModelEnumeration getEnumeration(String qualifiedEnumerationName) {
        ObjectModelEnumeration result = this.enumerations.get(qualifiedEnumerationName);
        if (result == null && log.isDebugEnabled()) {
            log.debug("Enumeration " + qualifiedEnumerationName + " not found in model");
        }
        return result;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public Set<String> getStereotypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : this.tagValues.entrySet()) {
            if (!"true".equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public boolean hasStereotype(String stereotypeName) {
        return this.tagValues.containsKey(stereotypeName);
    }

    @Override
    public void addStereotype(String stereotype) {
        this.tagValues.put(stereotype, "true");
    }

    @Override
    public void removeStereotype(String stereotype) {
        this.tagValues.remove(stereotype);
    }

    public void removePackage(String packageName) {
        for (ObjectModelClass objectModelClass : new LinkedHashSet<ObjectModelClass>(this.classes.values())) {
            if (!objectModelClass.getQualifiedName().startsWith(packageName + ".")) continue;
            this.classes.remove(objectModelClass.getQualifiedName());
        }
        for (ObjectModelInterface objectModelInterface : new LinkedHashSet<ObjectModelInterface>(this.interfaces.values())) {
            if (!objectModelInterface.getQualifiedName().startsWith(packageName + ".")) continue;
            this.classes.remove(objectModelInterface.getQualifiedName());
        }
        for (ObjectModelEnumeration objectModelEnumeration : new LinkedHashSet<ObjectModelEnumeration>(this.enumerations.values())) {
            if (!objectModelEnumeration.getQualifiedName().startsWith(packageName + ".")) continue;
            this.classes.remove(objectModelEnumeration.getQualifiedName());
        }
        this.packages.remove(packageName);
    }

    public void removeClass(String className) {
        this.classes.remove(className);
    }

    public void removeInterface(String interfaceName) {
        this.interfaces.remove(interfaceName);
    }

    public void removeEnumeration(String enumerationName) {
        this.enumerations.remove(enumerationName);
    }

    protected void mergePackages(ObjectModelPackageImpl initialPackage, ObjectModelPackageImpl additionalPackage) {
        Object description = "";
        Object sourceDoc = "";
        if (initialPackage.documentation != null) {
            description = (String)description + initialPackage.getDescription();
            if (initialPackage.documentation.contains("--")) {
                sourceDoc = (String)sourceDoc + initialPackage.getSourceDocumentation();
            }
        }
        if (additionalPackage.documentation != null) {
            if (!((String)description).equals("")) {
                description = (String)description + " - ";
            }
            description = (String)description + additionalPackage.getDescription();
            if (additionalPackage.documentation.contains("--")) {
                if (!((String)sourceDoc).equals("")) {
                    sourceDoc = (String)sourceDoc + " - ";
                }
                sourceDoc = (String)sourceDoc + additionalPackage.getSourceDocumentation();
            }
        }
        if (!((String)description).equals("") || !((String)sourceDoc).equals("")) {
            initialPackage.documentation = (String)description + "--" + (String)sourceDoc;
        }
        for (String comment : additionalPackage.getComments()) {
            if (initialPackage.comments.contains(comment)) continue;
            initialPackage.comments.add(comment);
        }
        for (String stereotype : additionalPackage.getStereotypes()) {
            if (initialPackage.getStereotypes().contains(stereotype)) continue;
            initialPackage.stereotypes.add(stereotype);
        }
        for (String tagName : additionalPackage.getTagValues().keySet()) {
            if (initialPackage.getTagValues().containsKey(tagName)) continue;
            initialPackage.tagValues.put(tagName, additionalPackage.getTagValue(tagName));
        }
    }

    protected void mergeClassifiers(ObjectModelClassifierImpl initialClazzifier, ObjectModelClassifierImpl additionalClazzifier) {
        Object description = "";
        Object sourceDoc = "";
        if (initialClazzifier.documentation != null) {
            description = (String)description + initialClazzifier.getDescription();
            if (initialClazzifier.documentation.contains("--")) {
                sourceDoc = (String)sourceDoc + initialClazzifier.getSourceDocumentation();
            }
        }
        if (additionalClazzifier.documentation != null) {
            if (!((String)description).equals("")) {
                description = (String)description + " - ";
            }
            description = (String)description + additionalClazzifier.getDescription();
            if (additionalClazzifier.documentation.contains("--")) {
                if (!((String)sourceDoc).equals("")) {
                    sourceDoc = (String)sourceDoc + " - ";
                }
                sourceDoc = (String)sourceDoc + additionalClazzifier.getSourceDocumentation();
            }
        }
        if (!((String)description).equals("") || !((String)sourceDoc).equals("")) {
            initialClazzifier.documentation = (String)description + "--" + (String)sourceDoc;
        }
        for (ObjectModelImplRef objectModelImplRef : additionalClazzifier.interfacesRefs) {
            if (!this.contains(initialClazzifier.interfacesRefs, objectModelImplRef)) {
                initialClazzifier.interfacesRefs.add(objectModelImplRef);
            }
            initialClazzifier.interfaces = null;
        }
        for (ObjectModelOperationImpl objectModelOperationImpl : additionalClazzifier.getOperations()) {
            if (this.contains(initialClazzifier.getOperations(), objectModelOperationImpl)) continue;
            initialClazzifier.operations.add(objectModelOperationImpl);
        }
        for (ObjectModelDependencyImpl objectModelDependencyImpl : additionalClazzifier.getDependencies()) {
            if (this.contains(initialClazzifier.getDependencies(), objectModelDependencyImpl)) continue;
            initialClazzifier.dependencies.add(objectModelDependencyImpl);
        }
        for (String string : additionalClazzifier.getComments()) {
            if (initialClazzifier.comments.contains(string)) continue;
            initialClazzifier.comments.add(string);
        }
        for (String string : additionalClazzifier.getStereotypes()) {
            if (initialClazzifier.getStereotypes().contains(string)) continue;
            initialClazzifier.addStereotype(string);
        }
        for (String string : additionalClazzifier.getTagValues().keySet()) {
            if (initialClazzifier.getTagValues().containsKey(string)) continue;
            initialClazzifier.tagValues.put(string, additionalClazzifier.getTagValue(string));
        }
    }

    private void mergeClasses(ObjectModelClassImpl initialClazz, ObjectModelClassImpl additionalClazz) {
        this.mergeClassifiers(initialClazz, additionalClazz);
        for (ObjectModelAttributeImpl objectModelAttributeImpl : additionalClazz.getAttributes()) {
            if (this.contains(initialClazz.getAttributes(), objectModelAttributeImpl)) continue;
            initialClazz.attributes.put(objectModelAttributeImpl.getName(), objectModelAttributeImpl);
            initialClazz.orderedAttributes.add(objectModelAttributeImpl);
        }
        for (ObjectModelImplRef objectModelImplRef : additionalClazz.superclassesRefs) {
            if (!this.contains(initialClazz.superclassesRefs, objectModelImplRef)) {
                initialClazz.superclassesRefs.add(objectModelImplRef);
            }
            initialClazz.superclasses = null;
        }
    }

    private void mergeAssociationClasses(ObjectModelAssociationClassImpl initialAssocClazz, ObjectModelAssociationClassImpl additionalAssocClazz) {
        this.mergeClasses(initialAssocClazz, additionalAssocClazz);
        for (ObjectModeImplAssociationClassParticipant participant : additionalAssocClazz.participantsRefs) {
            if (!this.contains(initialAssocClazz.participantsRefs, participant)) {
                initialAssocClazz.participantsRefs.add(participant);
            }
            initialAssocClazz.participantsAttributes = null;
            initialAssocClazz.participantsClassifiers = null;
        }
    }

    private boolean contains(Collection<ObjectModelAttribute> coll, ObjectModelAttributeImpl toFind) {
        for (ObjectModelAttribute attribute : coll) {
            if (!attribute.getName().equals(toFind.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Collection<?> coll, ObjectModelOperationImpl toFind) {
        return coll.contains(toFind);
    }

    private boolean contains(Collection<?> coll, ObjectModelImplRef toFind) {
        return coll.contains(toFind);
    }

    public ObjectModelImplTagValue addTagValue(ObjectModelImplTagValue tagValue) {
        if (tagValue == null) {
            return new ObjectModelImplTagValue();
        }
        this.tagValues.put(tagValue.getName(), tagValue.getValue());
        return tagValue;
    }

    @Override
    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    @Override
    public String getTagValue(String tagValue) {
        return tagValue == null ? null : this.tagValues.get(tagValue);
    }

    @Override
    public void addTagValue(String tagValue, String value) {
        String oldValue = this.getTagValue(tagValue);
        if (StringUtils.isNotEmpty((CharSequence)oldValue) && !oldValue.equals(value) && log.isWarnEnabled()) {
            log.warn("Replace tagValue '" + tagValue + "' (old:" + oldValue + ", new: " + value + ")");
        }
        this.tagValues.put(tagValue, value);
    }

    @Override
    public boolean hasTagValue(String tagValue) {
        return this.tagValues.containsKey(tagValue);
    }

    @Override
    public void removeTagValue(String tagvalue) {
        this.tagValues.remove(tagvalue);
    }

    @Override
    public <O> O getExtension(String reference, Class<O> extensionClass) throws RuntimeException {
        Object result;
        if (reference == null) {
            throw new NullPointerException("reference parameter can not be null in method ObjectModelImpl#getExtension");
        }
        if (extensionClass == null) {
            throw new NullPointerException("extensionClass parameter can not be null in method ObjectModelImpl#getExtension.");
        }
        Object object = this.extensions.get(reference);
        if (object != null && !extensionClass.isAssignableFrom(object.getClass())) {
            throw new ClassCastException("Invalid cast for " + extensionClass.getName());
        }
        if (object == null) {
            try {
                result = extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception eee) {
                throw new RuntimeException("Unable to create new extension '" + extensionClass.getName() + "' for '" + reference + "'", eee);
            }
            this.extensions.put(reference, result);
        } else {
            result = object;
        }
        return (O)result;
    }
}

