/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ExternalCacheExtension;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelDependencyImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;

public abstract class ObjectModelClassifierImpl
extends ObjectModelElementImpl
implements ObjectModelClassifier {
    protected boolean extern;
    protected String qualifiedName;
    protected String packageName;
    protected List<ObjectModelInterface> interfaces;
    protected List<ObjectModelImplRef> interfacesRefs = new ArrayList<ObjectModelImplRef>();
    protected List<ObjectModelOperation> operations = new ArrayList<ObjectModelOperation>();
    protected Map<String, ObjectModelAttribute> attributes = new HashMap<String, ObjectModelAttribute>();
    protected List<ObjectModelAttribute> orderedAttributes = new ArrayList<ObjectModelAttribute>();
    protected List<ObjectModelDependency> dependencies = new ArrayList<ObjectModelDependency>();
    protected String type;
    protected boolean inner;

    public String toString() {
        return this.getQualifiedName() + " implements " + this.getInterfaces();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.qualifiedName = this.packageName + "." + this.name;
    }

    public void setExtern(boolean extern) {
        this.extern = extern;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    @Override
    public boolean isInner() {
        return this.inner;
    }

    public void addInterface(ObjectModelImplRef ref) {
        this.interfacesRefs.add(ref);
        this.interfaces = null;
    }

    public void addOperation(ObjectModelOperationImpl operation) {
        operation.postInit();
        operation.setDeclaringElement(this);
        this.operations.add(operation);
    }

    public void addAttribute(ObjectModelAttributeImpl attribute) {
        attribute.postInit();
        attribute.setDeclaringElement(this);
        this.attributes.put(attribute.getName(), attribute);
        this.orderedAttributes.add(attribute);
    }

    public void addDependency(ObjectModelDependencyImpl dependency) {
        dependency.postInit();
        dependency.setClient(this);
        this.dependencies.add(dependency);
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isExtern() {
        return this.extern;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Collection<ObjectModelInterface> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<ObjectModelInterface>();
            for (ObjectModelImplRef ref : this.interfacesRefs) {
                ObjectModelInterfaceImpl interfacez = (ObjectModelInterfaceImpl)this.objectModelImpl.getInterface(ref.getName());
                if (interfacez == null) {
                    ExternalCacheExtension cache = this.objectModelImpl.getExtension("externalClassifiers", ExternalCacheExtension.class);
                    interfacez = cache.getCache(ref, ObjectModelInterfaceImpl.class);
                }
                this.interfaces.add(interfacez);
            }
        }
        return this.interfaces;
    }

    @Override
    public Collection<ObjectModelOperation> getOperations(String name) {
        ArrayList<ObjectModelOperation> result = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation op : this.getOperations()) {
            if (!name.equals(op.getName())) continue;
            result.add(op);
        }
        return result;
    }

    @Override
    public Collection<ObjectModelOperation> getOperations() {
        return this.operations;
    }

    @Override
    public Collection<ObjectModelOperation> getAllOtherOperations(boolean distinct) {
        return this.getAllInterfaceOperations(distinct);
    }

    @Override
    public Collection<ObjectModelOperation> getAllInterfaceOperations(boolean distinct) {
        AbstractCollection result = distinct ? new HashSet() : new LinkedList();
        this.getAllInterfaceOperations(result);
        return result;
    }

    protected Collection<ObjectModelOperation> getAllInterfaceOperations(Collection<ObjectModelOperation> result) {
        for (ObjectModelClassifier objectModelClassifier : this.getInterfaces()) {
            result.addAll(objectModelClassifier.getOperations());
            ((ObjectModelClassifierImpl)objectModelClassifier).getAllInterfaceOperations(result);
        }
        return result;
    }

    @Override
    public Collection<ObjectModelAttribute> getAttributes() {
        return this.orderedAttributes;
    }

    @Override
    public ObjectModelAttribute getAttribute(String attributeName) {
        return attributeName == null ? null : this.attributes.get(attributeName);
    }

    @Override
    public Collection<ObjectModelAttribute> getAllInterfaceAttributes() {
        LinkedList<ObjectModelAttribute> result = new LinkedList<ObjectModelAttribute>();
        this.getAllInterfaceAttributes(result);
        return result;
    }

    @Override
    public Collection<ObjectModelAttribute> getAllOtherAttributes() {
        Collection<ObjectModelAttribute> result = this.getAllInterfaceAttributes();
        return result;
    }

    protected Collection<ObjectModelAttribute> getAllInterfaceAttributes(Collection<ObjectModelAttribute> result) {
        for (ObjectModelInterface o : this.getInterfaces()) {
            ObjectModelClassifierImpl clazz = (ObjectModelClassifierImpl)((Object)o);
            result.addAll(clazz.getAttributes());
            clazz.getAllInterfaceAttributes(result);
        }
        return result;
    }

    @Override
    public Collection<ObjectModelDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public ObjectModelDependency getDependency(String name) {
        if (name.isEmpty()) {
            return null;
        }
        for (ObjectModelDependency dependency : this.dependencies) {
            if (!dependency.getName().equalsIgnoreCase(name)) continue;
            return dependency;
        }
        return null;
    }

    @Override
    public final boolean isClass() {
        return this instanceof ObjectModelClass;
    }

    @Override
    public final boolean isInterface() {
        return this instanceof ObjectModelInterface;
    }

    @Override
    public final boolean isEnum() {
        return this instanceof ObjectModelEnumeration;
    }
}

