/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.xml.ObjectModeImplAssociationClassParticipant;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;

public class ObjectModelAssociationClassImpl
extends ObjectModelClassImpl
implements ObjectModelAssociationClass {
    private static Logger log = LogManager.getLogger(ObjectModelAssociationClassImpl.class);
    protected List<ObjectModelAttribute> participantsAttributes;
    protected List<ObjectModelClassifier> participantsClassifiers;
    protected List<ObjectModeImplAssociationClassParticipant> participantsRefs = new ArrayList<ObjectModeImplAssociationClassParticipant>();

    public void addParticipant(ObjectModeImplAssociationClassParticipant participant) {
        participant.postInit();
        participant.setAssociationClass(this);
        this.participantsRefs.add(participant);
    }

    @Override
    public List<ObjectModelAttribute> getParticipantsAttributes() {
        if (this.participantsAttributes == null) {
            this.parseParticipantsRefs();
        }
        return this.participantsAttributes;
    }

    @Override
    public List<ObjectModelClassifier> getParticipantsClassifiers() {
        if (this.participantsClassifiers == null) {
            this.parseParticipantsRefs();
        }
        return this.participantsClassifiers;
    }

    protected void parseParticipantsRefs() {
        this.participantsClassifiers = new ArrayList<ObjectModelClassifier>();
        this.participantsAttributes = new ArrayList<ObjectModelAttribute>();
        for (ObjectModeImplAssociationClassParticipant ref : this.participantsRefs) {
            ObjectModelClassifier classifier = this.objectModelImpl.getClassifier(ref.getName());
            this.participantsClassifiers.add(classifier);
            ObjectModelAttribute attribute = null;
            if (classifier instanceof ObjectModelClass && (attribute = classifier.getAttribute(ref.getAttributeName())) == null) {
                log.warn("WARNING : Attribute " + ref.getAttributeName() + " not found on " + classifier.getQualifiedName());
                log.warn("WARNING : Assuming there is no navigability in this direction for the " + this.getQualifiedName() + " association class");
            }
            this.participantsAttributes.add(attribute);
        }
    }

    public Collection<ObjectModeImplAssociationClassParticipant> getParticipantsRefs() {
        return this.participantsRefs;
    }
}

